/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.commons.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;

public class SetTools<E> {
    private static Random rand = new Random();

    public Set<Set<E>> subsets(Collection<? extends E> elements) {
        HashSet subsets = new HashSet();
        if (elements.size() == 0) {
            subsets.add(new HashSet());
        } else {
            E element = elements.iterator().next();
            HashSet<E> remainingElements = new HashSet<E>(elements);
            remainingElements.remove(element);
            Set<Set<E>> subsubsets = this.subsets(remainingElements);
            for (Set<E> subsubset : subsubsets) {
                subsets.add(new HashSet<E>(subsubset));
                subsubset.add(element);
                subsets.add(new HashSet<E>(subsubset));
            }
        }
        return subsets;
    }

    public Set<Set<E>> subsets(Collection<? extends E> elements, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Size must be at least zero.");
        }
        HashSet subsets = new HashSet();
        if (size == 0) {
            subsets.add(new HashSet());
            return subsets;
        }
        if (elements.size() < size) {
            return subsets;
        }
        if (elements.size() == size) {
            subsets.add(new HashSet<E>(elements));
            return subsets;
        }
        if (size == 1) {
            for (E e : elements) {
                HashSet<E> set = new HashSet<E>();
                set.add(e);
                subsets.add(set);
            }
            return subsets;
        }
        E element = elements.iterator().next();
        HashSet<E> remainingElements = new HashSet<E>(elements);
        remainingElements.remove(element);
        Set<Set<E>> subsubsets = this.subsets(remainingElements, size - 1);
        for (Set<E> subsubset : subsubsets) {
            subsubset.add(element);
            subsets.add(new HashSet<E>(subsubset));
        }
        subsubsets = this.subsets(remainingElements, size);
        for (Set<E> subsubset : subsubsets) {
            subsets.add(new HashSet<E>(subsubset));
        }
        return subsets;
    }

    public Set<Set<E>> permutations(Set<Set<E>> partitions) {
        if (partitions.size() == 0) {
            partitions.add(new HashSet());
            return partitions;
        }
        HashSet result = new HashSet();
        Set<E> set = partitions.iterator().next();
        HashSet<Set<E>> remaining = new HashSet<Set<E>>(partitions);
        remaining.remove(set);
        Set<Set<E>> subresult = this.permutations(remaining);
        for (Set<E> subresultset : subresult) {
            for (E item : set) {
                HashSet<E> newSet = new HashSet<E>();
                newSet.addAll(subresultset);
                newSet.add(item);
                result.add(newSet);
            }
        }
        return result;
    }

    public Set<Set<E>> irreducibleHittingSets(Set<Set<E>> sets) {
        if (sets.size() == 0) {
            return new HashSet<Set<E>>();
        }
        if (sets.size() == 1) {
            HashSet result = new HashSet();
            for (E e : sets.iterator().next()) {
                HashSet<E> h = new HashSet<E>();
                h.add(e);
                result.add(h);
            }
            return result;
        }
        Set<E> current = sets.iterator().next();
        HashSet<Set<Set<E>>> new_sets = new HashSet<Set<Set<E>>>();
        new_sets.addAll(sets);
        new_sets.remove(current);
        Set<Set<Set<E>>> result = this.irreducibleHittingSets(new_sets);
        HashSet<Set<E>> new_result = new HashSet<Set<E>>();
        for (Set<E> set : result) {
            HashSet tmp = new HashSet();
            tmp.addAll(current);
            tmp.retainAll(set);
            if (tmp.size() == 0) {
                for (Object e : current) {
                    tmp = new HashSet();
                    tmp.addAll(set);
                    tmp.add(e);
                    new_result.add(tmp);
                }
                continue;
            }
            new_result.add(set);
        }
        result.clear();
        block3: for (Set<E> set : new_result) {
            result.add(set);
            for (Set set2 : new_result) {
                if (set == set2 || !set.containsAll(set2)) continue;
                result.remove(set);
                continue block3;
            }
        }
        return result;
    }

    public boolean hasEmptyIntersection(Set<Set<E>> sets) {
        HashSet i = new HashSet();
        i.addAll(sets.iterator().next());
        for (Set<E> s : sets) {
            i.retainAll(s);
        }
        return i.isEmpty();
    }

    public Set<E> getUnion(Set<Set<E>> sets) {
        HashSet<E> result = new HashSet<E>();
        for (Set<E> s : sets) {
            result.addAll(s);
        }
        return result;
    }

    public Set<Set<Set<E>>> getBipartitions(Set<E> set) {
        Set<Set<E>> subsets = this.subsets(set);
        HashSet bipartitions = new HashSet();
        for (Set<E> partition1 : subsets) {
            HashSet<E> partition2 = new HashSet<E>(set);
            partition2.removeAll(partition1);
            HashSet<Set<E>> bipartition = new HashSet<Set<E>>();
            bipartition.add(partition1);
            bipartition.add(partition2);
            bipartitions.add(bipartition);
        }
        return bipartitions;
    }

    public Set<E> symmetricDifference(Collection<E> s, Collection<E> t) {
        HashSet<E> result = new HashSet<E>();
        HashSet<E> isec = new HashSet<E>(s);
        isec.retainAll(t);
        result.addAll(s);
        result.addAll(t);
        result.removeAll(isec);
        return result;
    }

    public Set<Set<Collection<E>>> independentSets(Set<Collection<E>> sets, int cardinality) {
        HashSet<Set<Collection<Set<Collection<E>>>>> result = new HashSet<Set<Collection<Set<Collection<E>>>>>();
        Set<Set<Collection<E>>> candidates = new SetTools<Collection<E>>().subsets(sets, cardinality);
        for (Set<Collection<E>> candidate : candidates) {
            if (!this.isIndependent(candidate)) continue;
            result.add(candidate);
        }
        return result;
    }

    public boolean isIndependent(Set<Collection<E>> set) {
        for (Collection<E> s1 : set) {
            for (Collection<E> s2 : set) {
                if (s1 == s2) continue;
                for (E elem : s1) {
                    if (!s2.contains(elem)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public E randomElement(Collection<E> set) {
        Iterator<E> it = set.iterator();
        for (int idx = rand.nextInt(set.size()); idx > 0; --idx) {
            it.next();
        }
        return it.next();
    }
}

