/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.commons.util;

import java.util.LinkedList;
import java.util.List;

public class VectorTools {
    public static double[] midPoint(double[] left, double[] right) {
        if (left.length != right.length) {
            throw new IllegalArgumentException("The given arrays differ in their dimension.");
        }
        double[] result = new double[left.length];
        for (int i = 0; i < left.length; ++i) {
            result[i] = (left[i] + right[i]) / 2.0;
        }
        return result;
    }

    public static double sum(double[] v) {
        double result = 0.0;
        for (double d : v) {
            result += d;
        }
        return result;
    }

    public static double manhattanDistance(double[] left, double[] right) {
        if (left.length != right.length) {
            throw new IllegalArgumentException("The given arrays differ in their dimension.");
        }
        double result = 0.0;
        for (int i = 0; i < left.length; ++i) {
            result += Math.abs(left[i] - right[i]);
        }
        return result;
    }

    public static double manhattanDistance(List<Double> left, List<Double> right) {
        if (left.size() != right.size()) {
            throw new IllegalArgumentException("The given lists differ in their dimension.");
        }
        double result = 0.0;
        for (int i = 0; i < left.size(); ++i) {
            result += Math.abs(left.get(i) - right.get(i));
        }
        return result;
    }

    public static double manhattanDistanceToZero(List<Double> values) {
        LinkedList<Double> zero = new LinkedList<Double>();
        for (int i = 0; i < values.size(); ++i) {
            zero.add(0.0);
        }
        return VectorTools.manhattanDistance(values, zero);
    }

    public static double manhattanDistanceToZero(double[] values) {
        double[] zero = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            zero[i] = 0.0;
        }
        return VectorTools.manhattanDistance(values, zero);
    }

    public static double[] normalize(double[] v, double sum) {
        double[] result = new double[v.length];
        double oldsum = VectorTools.sum(v);
        for (int i = 0; i < v.length; ++i) {
            result[i] = v[i] / oldsum * sum;
        }
        return result;
    }
}

