/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.commons.util.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.util.Triple;
import net.sf.tweety.commons.util.rules.Rule;
import net.sf.tweety.commons.util.rules.RuleSet;

public class Derivation<T extends Rule<?, ?>>
extends ArrayList<T> {
    private static final long serialVersionUID = 1L;

    public Derivation(List<T> rules) {
        super(rules);
    }

    public Formula getConclusion() {
        RuleSet ruleSet = new RuleSet(this);
        Set<Formula> conclusions = ruleSet.getConclusions();
        Set<Formula> premises = ruleSet.getPremises();
        conclusions.removeAll(premises);
        return conclusions.iterator().next();
    }

    public static <S extends Rule<?, ?>> Set<Derivation<S>> allDerivations(Collection<? extends S> rules) {
        RuleSet<S> theRules = new RuleSet<S>(rules);
        HashSet<Derivation<S>> allDerivations = new HashSet<Derivation<S>>();
        for (Formula f : theRules.getConclusions()) {
            allDerivations.addAll(Derivation.allDerivations(rules, f));
        }
        return allDerivations;
    }

    public static <S extends Rule<?, ?>> Set<Derivation<S>> allDerivations(Collection<? extends S> rules, Formula conclusion) {
        Stack stack = new Stack();
        Triple initial = new Triple();
        initial.setFirst(new ArrayList());
        initial.getFirst();
        initial.setSecond(new HashSet());
        ((Set)initial.getSecond()).add(conclusion);
        initial.setThird(new RuleSet<S>(rules));
        stack.add(initial);
        HashSet<Derivation<S>> derivations = new HashSet<Derivation<S>>();
        while (!stack.isEmpty()) {
            Triple derivation = (Triple)stack.pop();
            if (((Set)derivation.getSecond()).isEmpty()) {
                derivations.add(new Derivation((List)derivation.getFirst()));
                continue;
            }
            for (Formula f : (Set)derivation.getSecond()) {
                for (Rule r : ((RuleSet)derivation.getThird()).getRulesWithConclusion(f)) {
                    Triple newDerivation = new Triple();
                    newDerivation.setFirst(new ArrayList((Collection)derivation.getFirst()));
                    ((List)newDerivation.getFirst()).add(r);
                    newDerivation.setSecond(new HashSet((Collection)derivation.getSecond()));
                    ((Set)newDerivation.getSecond()).remove(f);
                    ((Set)newDerivation.getSecond()).addAll(r.getPremise());
                    newDerivation.setThird(new RuleSet((Collection)derivation.getThird()));
                    ((RuleSet)newDerivation.getThird()).removeAll(((RuleSet)derivation.getThird()).getRulesWithConclusion(f));
                    boolean noder = false;
                    for (Formula g : (Set)newDerivation.getSecond()) {
                        for (Rule s : (List)newDerivation.getFirst()) {
                            if (!s.getConclusion().equals(g)) continue;
                            noder = true;
                            break;
                        }
                        if (!noder) continue;
                        break;
                    }
                    if (noder) continue;
                    stack.add(newDerivation);
                }
            }
        }
        return derivations;
    }

    public boolean isFounded() {
        HashSet toProve = new HashSet();
        Iterator rules = this.iterator();
        toProve.addAll(((Rule)rules.next()).getPremise());
        while (rules.hasNext()) {
            Rule rule = (Rule)rules.next();
            toProve.remove(rule.getConclusion());
            toProve.addAll(rule.getPremise());
        }
        return toProve.isEmpty();
    }

    public boolean isMinimal() {
        RuleSet ruleSet = new RuleSet(this);
        for (Formula f : ruleSet.getConclusions()) {
            if (ruleSet.getRulesWithConclusion(f).size() <= 1) continue;
            return false;
        }
        Set<Formula> conclusions = ruleSet.getConclusions();
        Set<Formula> premises = ruleSet.getPremises();
        conclusions.removeAll(premises);
        return conclusions.size() == 1;
    }

    @Override
    public int hashCode() {
        HashSet thisSet = new HashSet(this);
        return thisSet.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashSet thisSet = new HashSet(this);
        return thisSet.equals(new HashSet((Derivation)obj));
    }
}

