/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.commons.util.rules;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.Signature;
import net.sf.tweety.commons.util.rules.Rule;

public class RuleSet<T extends Rule<?, ?>>
extends HashSet<T> {
    private static final long serialVersionUID = 1L;

    public RuleSet() {
    }

    public RuleSet(Collection<? extends T> rules) {
        super(rules);
    }

    public Set<T> getRulesWithConclusion(Formula f) {
        HashSet<Rule> rules = new HashSet<Rule>();
        for (Rule rule : this) {
            if (!rule.getConclusion().equals(f)) continue;
            rules.add(rule);
        }
        return rules;
    }

    public Set<Formula> getConclusions() {
        HashSet<Formula> conclusions = new HashSet<Formula>();
        for (Rule rule : this) {
            conclusions.add((Formula)rule.getConclusion());
        }
        return conclusions;
    }

    public Set<Formula> getPremises() {
        HashSet<Formula> premises = new HashSet<Formula>();
        for (Rule rule : this) {
            premises.addAll(rule.getPremise());
        }
        return premises;
    }

    public RuleSet<T> getSyntacticModule(Formula f) {
        boolean changed;
        RuleSet<T> ruleset = new RuleSet<T>();
        Signature sig = f.getSignature();
        do {
            changed = false;
            for (Rule rule : this) {
                if (ruleset.contains(rule) || !rule.getSignature().isOverlappingSignature(sig)) continue;
                ruleset.add(rule);
                changed = true;
                sig.addSignature(rule.getSignature());
            }
        } while (changed);
        return ruleset;
    }
}

