/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.graphs;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import net.sf.tweety.commons.util.SetTools;
import net.sf.tweety.graphs.DirectedEdge;
import net.sf.tweety.graphs.Edge;
import net.sf.tweety.graphs.Graph;
import net.sf.tweety.graphs.Node;
import net.sf.tweety.graphs.UndirectedEdge;
import net.sf.tweety.graphs.WeightedEdge;
import net.sf.tweety.math.matrix.Matrix;
import net.sf.tweety.math.term.IntegerConstant;
import net.sf.tweety.math.term.Term;

public class DefaultGraph<T extends Node>
implements Graph<T> {
    private Set<T> nodes = new HashSet<T>();
    private Set<Edge<T>> edges = new HashSet<Edge<T>>();

    @Override
    public boolean add(T node) {
        return this.nodes.add(node);
    }

    @Override
    public boolean add(Edge<T> edge) {
        if (!this.nodes.contains(edge.getNodeA()) || !this.nodes.contains(edge.getNodeB())) {
            throw new IllegalArgumentException("The edge connects node that are not in this graph.");
        }
        return this.edges.add(edge);
    }

    @Override
    public Collection<T> getNodes() {
        return this.nodes;
    }

    @Override
    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    @Override
    public Collection<Edge<T>> getEdges() {
        return this.edges;
    }

    @Override
    public Iterator<T> iterator() {
        return this.nodes.iterator();
    }

    @Override
    public boolean contains(Object obj) {
        return this.nodes.contains(obj) || this.edges.contains(obj);
    }

    @Override
    public Collection<T> getNeighbors(T node) {
        if (!this.nodes.contains(node)) {
            throw new IllegalArgumentException("The node is not in this graph.");
        }
        HashSet<T> neighbors = new HashSet<T>();
        for (Edge<T> edge : this.edges) {
            if (edge.getNodeA() == node) {
                neighbors.add(edge.getNodeB());
                continue;
            }
            if (edge.getNodeB() != node) continue;
            neighbors.add(edge.getNodeA());
        }
        return neighbors;
    }

    @Override
    public Collection<T> getChildren(Node node) {
        if (!this.nodes.contains(node)) {
            throw new IllegalArgumentException("The node is not in this graph.");
        }
        HashSet<T> children = new HashSet<T>();
        for (Edge<T> edge : this.edges) {
            if (edge.getNodeA() == node) {
                children.add(edge.getNodeB());
                continue;
            }
            if (edge.getNodeB() != node || !(edge instanceof UndirectedEdge)) continue;
            children.add(edge.getNodeA());
        }
        return children;
    }

    @Override
    public Collection<T> getParents(Node node) {
        if (!this.nodes.contains(node)) {
            throw new IllegalArgumentException("The node is not in this graph.");
        }
        HashSet<T> parents = new HashSet<T>();
        for (Edge<T> edge : this.edges) {
            if (edge.getNodeB() == node) {
                parents.add(edge.getNodeA());
                continue;
            }
            if (edge.getNodeA() != node || !(edge instanceof UndirectedEdge)) continue;
            parents.add(edge.getNodeB());
        }
        return parents;
    }

    @Override
    public boolean areAdjacent(T a, T b) {
        return this.getEdge(a, b) != null;
    }

    @Override
    public Edge<T> getEdge(T a, T b) {
        for (Edge<T> edge : this.edges) {
            if (!edge.getNodeA().equals(a) && (!(edge instanceof UndirectedEdge) || !edge.getNodeB().equals(a)) || !edge.getNodeB().equals(b) && (!(edge instanceof UndirectedEdge) || !edge.getNodeA().equals(b))) continue;
            return edge;
        }
        return null;
    }

    @Override
    public boolean existsDirectedPath(T node1, T node2) {
        return DefaultGraph.existsDirectedPath(this, node1, node2);
    }

    @Override
    public Matrix getAdjacencyMatrix() {
        Matrix m = new Matrix(this.getNumberOfNodes(), this.getNumberOfNodes());
        int i = 0;
        for (Node a : this.nodes) {
            int j = 0;
            for (Node b : this.nodes) {
                m.setEntry(i, j, (Term)new IntegerConstant(this.areAdjacent(a, b) ? 1 : 0));
                ++j;
            }
            ++i;
        }
        return m;
    }

    @Override
    public String toString() {
        return "<" + this.nodes + "," + this.edges + ">";
    }

    @Override
    public Graph<T> getComplementGraph(int selfloops) {
        DefaultGraph<Node> comp = new DefaultGraph<Node>();
        for (Node node : this) {
            comp.add(node);
        }
        for (Node node1 : this) {
            for (Node node2 : this) {
                if (node1 == node2) {
                    if (selfloops == 2) {
                        if (this.areAdjacent(node1, node2)) continue;
                        comp.add(new DirectedEdge<Node>(node1, node2));
                        continue;
                    }
                    if (selfloops != 1 || !this.areAdjacent(node1, node2)) continue;
                    comp.add(new DirectedEdge<Node>(node1, node2));
                    continue;
                }
                if (this.areAdjacent(node1, node2)) continue;
                comp.add(new DirectedEdge<Node>(node1, node2));
            }
        }
        return comp;
    }

    @Override
    public boolean hasSelfLoops() {
        for (Node node1 : this) {
            if (!this.areAdjacent(node1, node1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWeightedGraph() {
        for (Edge<T> e : this.edges) {
            if (e instanceof WeightedEdge) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<Collection<T>> getStronglyConnectedComponents() {
        return DefaultGraph.getStronglyConnectedComponents(this);
    }

    private static <S extends Node> int getStronglyConnectedComponentsRec(int idx, S v, Stack<S> stack, Collection<Collection<S>> sccs, Graph<S> g, Map<S, Integer> index, Map<S, Integer> lowlink) {
        index.put(v, idx);
        lowlink.put(v, idx);
        ++idx;
        stack.push(v);
        for (Node w : g.getChildren(v)) {
            if (!index.containsKey(w)) {
                idx = DefaultGraph.getStronglyConnectedComponentsRec(idx, w, stack, sccs, g, index, lowlink);
                lowlink.put(v, Math.min(lowlink.get(v), lowlink.get(w)));
                continue;
            }
            if (!stack.contains(w)) continue;
            lowlink.put(v, Math.min(lowlink.get(v), index.get(w)));
        }
        if (lowlink.get(v).equals(index.get(v))) {
            Node w;
            HashSet<Node> scc = new HashSet<Node>();
            do {
                w = (Node)stack.pop();
                scc.add(w);
            } while (!v.equals(w));
            sccs.add(scc);
        }
        return idx;
    }

    public static <S extends Node> Collection<Collection<S>> getStronglyConnectedComponents(Graph<S> g) {
        int idx = 0;
        Stack stack = new Stack();
        HashSet<Collection<S>> sccs = new HashSet<Collection<S>>();
        HashMap index = new HashMap();
        HashMap lowlink = new HashMap();
        for (Node v : g) {
            if (index.containsKey(v)) continue;
            idx = DefaultGraph.getStronglyConnectedComponentsRec(idx, v, stack, sccs, g, index, lowlink);
        }
        return sccs;
    }

    @Override
    public Collection<Graph<T>> getSubgraphs() {
        return DefaultGraph.getSubgraphs(this);
    }

    public static <S extends Node> Collection<Graph<S>> getSubgraphs(Graph<S> g) {
        HashSet<Graph<S>> result = new HashSet<Graph<S>>();
        Set subNodes = new SetTools().subsets(g.getNodes());
        for (Set nodes : subNodes) {
            Set edges = new SetTools().subsets((Collection)((Set)g.getRestriction(nodes).getEdges()));
            for (Set es : edges) {
                DefaultGraph newg = new DefaultGraph();
                newg.nodes.addAll(nodes);
                newg.edges.addAll(es);
                result.add(newg);
            }
        }
        return result;
    }

    @Override
    public DefaultGraph<T> getRestriction(Collection<T> nodes) {
        DefaultGraph<T> graph = new DefaultGraph<T>();
        graph.nodes.addAll(nodes);
        for (Edge<T> e : this.edges) {
            if (!nodes.contains(e.getNodeA()) || !nodes.contains(e.getNodeB())) continue;
            graph.add(e);
        }
        return graph;
    }

    public static <S extends Node> boolean existsDirectedPath(Graph<S> g, S node1, S node2) {
        if (!g.getNodes().contains(node1) || !g.getNodes().contains(node2)) {
            throw new IllegalArgumentException("The nodes are not in this graph.");
        }
        if (node1.equals(node2)) {
            return true;
        }
        Stack<S> stack = new Stack<S>();
        HashSet<Node> visited = new HashSet<Node>();
        stack.add(node1);
        while (!stack.isEmpty()) {
            Node node = (Node)stack.pop();
            visited.add(node);
            if (node.equals(node2)) {
                return true;
            }
            stack.addAll(g.getChildren(node));
            stack.removeAll(visited);
        }
        return false;
    }

    public static <S extends Node> boolean containsCycle(Graph<S> g) {
        HashMap<Node, Integer> states = new HashMap<Node, Integer>();
        for (Node n : g) {
            if (!DefaultGraph.containsBackEdge(n, states, g)) continue;
            return true;
        }
        return false;
    }

    public static <S extends Node> boolean containsBackEdge(Node parent, Map<Node, Integer> states, Graph<S> g) {
        boolean OPEN = false;
        boolean CLOSED = true;
        states.put(parent, 0);
        for (Node child_node : g.getChildren(parent)) {
            if (!(!states.containsKey(child_node) ? DefaultGraph.containsBackEdge(child_node, states, g) : states.get(child_node) == 0)) continue;
            return true;
        }
        states.put(parent, 1);
        return false;
    }

    public static <S extends Node> Set<Stack<S>> getCyclesExcludingSelfLoops(Graph<S> g) {
        HashSet<Stack<S>> results = new HashSet<Stack<S>>();
        results.addAll(DefaultGraph.getCyclesIncludingSelfLoops(g));
        Collection<Edge<S>> edges = g.getEdges();
        for (Edge<S> singleEdge : edges) {
            if (!singleEdge.getNodeA().equals(singleEdge.getNodeB())) continue;
            Stack<S> removeFromResults = new Stack<S>();
            removeFromResults.push(singleEdge.getNodeA());
            removeFromResults.push(singleEdge.getNodeA());
            results.remove(removeFromResults);
        }
        return results;
    }

    public static <S extends Node> Set<Stack<S>> getCyclesIncludingSelfLoops(Graph<S> g) {
        if (!DefaultGraph.containsCycle(g)) {
            return new HashSet<Stack<S>>();
        }
        HashMap ag = new HashMap();
        HashMap b = new HashMap();
        HashMap<Node, Boolean> blocked = new HashMap<Node, Boolean>();
        Stack stack = new Stack();
        HashSet<Stack<S>> results = new HashSet<Stack<S>>();
        Collection<Collection<S>> stronglyConnectedComponents = DefaultGraph.getStronglyConnectedComponents(g);
        for (Collection singleComponent : stronglyConnectedComponents) {
            for (Node node : singleComponent) {
                Collection<S> children = g.getChildren(node);
                Set childrenInSCC = children.stream().filter(child -> singleComponent.contains(child)).collect(Collectors.toSet());
                ag.put(node, childrenInSCC);
            }
        }
        for (Collection singleComponent : stronglyConnectedComponents) {
            for (Node s : singleComponent) {
                for (Node i : singleComponent) {
                    blocked.put(i, false);
                    b.put(i, new HashSet());
                }
                DefaultGraph.circuit(s, stack, blocked, ag, b, s, results);
            }
        }
        return results;
    }

    private static <S extends Node> void unblock(S u, Map<S, Boolean> blocked, Map<S, Set<S>> b) {
        blocked.put(u, false);
        for (Node w : b.get(u)) {
            b.remove(w);
            if (!blocked.get(w).booleanValue()) continue;
            DefaultGraph.unblock(w, blocked, b);
        }
    }

    private static <S extends Node> Boolean circuit(S v, Stack<S> stack, Map<S, Boolean> blocked, Map<S, Set<S>> ak, Map<S, Set<S>> b, S s, Set<Stack<S>> results) {
        Boolean f = false;
        stack.push(v);
        blocked.put(v, true);
        for (Node w : ak.get(v)) {
            if (w == s) {
                Stack<S> singleResult = new Stack<S>();
                singleResult.addAll(stack);
                singleResult.push(s);
                results.add(singleResult);
                f = true;
                continue;
            }
            if (blocked.get(w).booleanValue() || !DefaultGraph.circuit(w, stack, blocked, ak, b, s, results).booleanValue()) continue;
            f = true;
        }
        if (f.booleanValue()) {
            DefaultGraph.unblock(v, blocked, b);
        } else {
            for (Node w : ak.get(v)) {
                b.get(w).add(v);
            }
        }
        stack.pop();
        return f;
    }

    public static <S extends Node> Collection<Graph<S>> getComponents(Graph<S> g) {
        HashSet<Graph<S>> components = new HashSet<Graph<S>>();
        Stack notVisited = new Stack();
        notVisited.addAll(g.getNodes());
        while (!notVisited.isEmpty()) {
            DefaultGraph<Node> singleComponent = new DefaultGraph<Node>();
            Node startNode = (Node)notVisited.pop();
            LinkedList<Node> queue = new LinkedList<Node>();
            queue.add(startNode);
            while (!queue.isEmpty()) {
                Node currentNode = (Node)queue.poll();
                singleComponent.add(currentNode);
                Collection<S> parentNodes = g.getParents(currentNode);
                Collection<S> childNodes = g.getChildren(currentNode);
                HashSet<S> adjacentNodes = new HashSet<S>();
                adjacentNodes.addAll(parentNodes);
                adjacentNodes.addAll(childNodes);
                Collection filteredAdjacentNodes = adjacentNodes.stream().filter(node -> notVisited.contains(node)).collect(Collectors.toList());
                queue.addAll(filteredAdjacentNodes);
                notVisited.removeAll(filteredAdjacentNodes);
                for (Node singleParentNode : parentNodes) {
                    singleComponent.add(singleParentNode);
                    singleComponent.add(g.getEdge(singleParentNode, currentNode));
                }
                for (Node singleChildNode : childNodes) {
                    singleComponent.add(singleChildNode);
                    singleComponent.add(g.getEdge(currentNode, singleChildNode));
                }
            }
            components.add(singleComponent);
        }
        return components;
    }

    public static <S extends Node> Collection<Graph<S>> getInducedSubgraphs(Graph<S> g) {
        HashSet<Graph<S>> resultingInducedSubgraphs = new HashSet<Graph<S>>();
        Set subsetOfNodes = new SetTools().subsets(g.getNodes());
        for (Set singleSubset : subsetOfNodes) {
            DefaultGraph<Node> singleInducedSubgraph = new DefaultGraph<Node>();
            for (Node singleNode : singleSubset) {
                singleInducedSubgraph.add(singleNode);
            }
            Collection<Edge<S>> edges = g.getEdges();
            Collection filteredEdges = edges.stream().filter(edge -> singleSubset.contains(edge.getNodeA()) && singleSubset.contains(edge.getNodeB())).collect(Collectors.toList());
            for (Edge singleEdge : filteredEdges) {
                singleInducedSubgraph.add(g.getEdge(singleEdge.getNodeA(), singleEdge.getNodeB()));
            }
            resultingInducedSubgraphs.add(singleInducedSubgraph);
        }
        return resultingInducedSubgraphs;
    }
}

