/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.graphs;

import java.util.Collection;
import java.util.Iterator;
import net.sf.tweety.graphs.Edge;
import net.sf.tweety.graphs.Node;
import net.sf.tweety.math.matrix.Matrix;

public interface Graph<T extends Node>
extends Iterable<T> {
    public static final int IGNORE_SELFLOOPS = 1;
    public static final int INVERT_SELFLOOPS = 2;
    public static final int REMOVE_SELFLOOPS = 3;

    public boolean add(T var1);

    public boolean add(Edge<T> var1);

    public Collection<T> getNodes();

    public int getNumberOfNodes();

    public boolean areAdjacent(T var1, T var2);

    public Edge<T> getEdge(T var1, T var2);

    public Collection<? extends Edge<? extends T>> getEdges();

    @Override
    public Iterator<T> iterator();

    public boolean contains(Object var1);

    public Collection<T> getChildren(Node var1);

    public Collection<T> getParents(Node var1);

    public boolean existsDirectedPath(T var1, T var2);

    public Collection<T> getNeighbors(T var1);

    public Matrix getAdjacencyMatrix();

    public Graph<T> getComplementGraph(int var1);

    public Collection<Collection<T>> getStronglyConnectedComponents();

    public Collection<Graph<T>> getSubgraphs();

    public Graph<T> getRestriction(Collection<T> var1);

    public boolean hasSelfLoops();

    public boolean isWeightedGraph();

    public String toString();
}

