/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.graphs.examples;

import net.sf.tweety.graphs.DefaultGraph;
import net.sf.tweety.graphs.DirectedEdge;
import net.sf.tweety.graphs.SimpleNode;
import net.sf.tweety.graphs.util.GraphUtil;

public class GraphExample {
    public void run() {
        DefaultGraph<SimpleNode> g = new DefaultGraph<SimpleNode>();
        SimpleNode[] nodes = new SimpleNode[]{new SimpleNode("A"), new SimpleNode("B"), new SimpleNode("C"), new SimpleNode("D"), new SimpleNode("E"), new SimpleNode("F"), new SimpleNode("G"), new SimpleNode("H"), new SimpleNode("I"), new SimpleNode("J"), new SimpleNode("K")};
        for (SimpleNode n : nodes) {
            g.add(n);
        }
        g.add(new DirectedEdge<SimpleNode>(nodes[1], nodes[2]));
        g.add(new DirectedEdge<SimpleNode>(nodes[2], nodes[1]));
        g.add(new DirectedEdge<SimpleNode>(nodes[3], nodes[0]));
        g.add(new DirectedEdge<SimpleNode>(nodes[3], nodes[1]));
        g.add(new DirectedEdge<SimpleNode>(nodes[4], nodes[3]));
        g.add(new DirectedEdge<SimpleNode>(nodes[4], nodes[1]));
        g.add(new DirectedEdge<SimpleNode>(nodes[4], nodes[5]));
        g.add(new DirectedEdge<SimpleNode>(nodes[5], nodes[1]));
        g.add(new DirectedEdge<SimpleNode>(nodes[5], nodes[4]));
        g.add(new DirectedEdge<SimpleNode>(nodes[6], nodes[1]));
        g.add(new DirectedEdge<SimpleNode>(nodes[6], nodes[4]));
        g.add(new DirectedEdge<SimpleNode>(nodes[7], nodes[1]));
        g.add(new DirectedEdge<SimpleNode>(nodes[7], nodes[4]));
        g.add(new DirectedEdge<SimpleNode>(nodes[8], nodes[1]));
        g.add(new DirectedEdge<SimpleNode>(nodes[8], nodes[4]));
        g.add(new DirectedEdge<SimpleNode>(nodes[9], nodes[4]));
        g.add(new DirectedEdge<SimpleNode>(nodes[10], nodes[4]));
        for (SimpleNode n : nodes) {
            System.out.println(n + "\t" + GraphUtil.pageRank(g, n, 0.85, 1.0E-5));
        }
    }

    public void run2() {
        DefaultGraph<SimpleNode> g = new DefaultGraph<SimpleNode>();
        SimpleNode[] nodes = new SimpleNode[]{new SimpleNode("A"), new SimpleNode("B"), new SimpleNode("C"), new SimpleNode("D"), new SimpleNode("E")};
        for (SimpleNode simpleNode : nodes) {
            g.add(simpleNode);
        }
        g.add(new DirectedEdge<SimpleNode>(nodes[0], nodes[1]));
        g.add(new DirectedEdge<SimpleNode>(nodes[1], nodes[2]));
        g.add(new DirectedEdge<SimpleNode>(nodes[2], nodes[3]));
        System.out.println(g);
        System.out.println();
        for (SimpleNode simpleNode : GraphUtil.eigenvalues(g)) {
            System.out.println(simpleNode);
        }
    }

    public static void main(String[] args) {
        new GraphExample().run();
    }
}

