/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.graphs.orders;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.tweety.graphs.DefaultGraph;
import net.sf.tweety.graphs.DirectedEdge;
import net.sf.tweety.graphs.Node;

public class Order<T> {
    private DefaultGraph<OrderNode> defaultGraph = new DefaultGraph();
    private Map<T, OrderNode> nodes = new HashMap<T, OrderNode>();

    public Order(Collection<T> objects) {
        for (T object : objects) {
            OrderNode node = new OrderNode();
            this.nodes.put(object, node);
            this.defaultGraph.add(node);
        }
    }

    public void removeNode(T n) {
        this.nodes.remove(n);
        this.defaultGraph = this.defaultGraph.getRestriction((Collection)this.nodes.values());
    }

    public void setOrderedBefore(T object1, T object2) {
        if (!this.nodes.containsKey(object1) || !this.nodes.containsKey(object2)) {
            throw new IllegalArgumentException("Objects cannot be ordered by this order as they are not contained in the domain.");
        }
        this.defaultGraph.add(new DirectedEdge<OrderNode>(this.nodes.get(object1), this.nodes.get(object2)));
    }

    public boolean isOrderedBefore(T object1, T object2) {
        OrderNode node1 = this.nodes.get(object1);
        OrderNode node2 = this.nodes.get(object2);
        return this.defaultGraph.existsDirectedPath(node1, node2);
    }

    public boolean isComparable(T object1, T object2) {
        OrderNode node2;
        OrderNode node1 = this.nodes.get(object1);
        return this.defaultGraph.existsDirectedPath(node1, node2 = this.nodes.get(object2)) || this.defaultGraph.existsDirectedPath(node2, node1);
    }

    public Collection<T> getElements() {
        return this.nodes.keySet();
    }

    public String toString() {
        return this.defaultGraph.toString();
    }

    public DefaultGraph<OrderNode> getDefaultGraph() {
        return this.defaultGraph;
    }

    public Map<T, OrderNode> getNodes() {
        return this.nodes;
    }

    private class OrderNode
    implements Node {
        private OrderNode() {
        }
    }
}

