/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.graphs.util;

import Jama.EigenvalueDecomposition;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.sf.tweety.commons.util.MapTools;
import net.sf.tweety.commons.util.Pair;
import net.sf.tweety.graphs.DirectedEdge;
import net.sf.tweety.graphs.Graph;
import net.sf.tweety.graphs.Node;
import net.sf.tweety.graphs.UndirectedEdge;
import net.sf.tweety.math.ComplexNumber;
import net.sf.tweety.math.matrix.Matrix;

public abstract class GraphUtil {
    private static Map<Graph<? extends Node>, Map<Double, Map<Double, Map<Node, Double>>>> archivePageRank = new HashMap<Graph<? extends Node>, Map<Double, Map<Double, Map<Node, Double>>>>();
    private static Map<Graph<? extends Node>, Map<Double, Map<Node, Double>>> archiveHITSAuthRank = new HashMap<Graph<? extends Node>, Map<Double, Map<Node, Double>>>();
    private static Map<Graph<? extends Node>, Map<Double, Map<Node, Double>>> archiveHITSHubRank = new HashMap<Graph<? extends Node>, Map<Double, Map<Node, Double>>>();

    public static Double pageRank(Graph<? extends Node> g, Node n, double dampingFactor, double precision) {
        double maxDiff;
        if (archivePageRank.containsKey(g) && archivePageRank.get(g).containsKey(dampingFactor) && archivePageRank.get(g).get(dampingFactor).containsKey(precision)) {
            return archivePageRank.get(g).get(dampingFactor).get(precision).get(n);
        }
        HashMap<Node, Double> pageRanks = new HashMap<Node, Double>();
        double m = g.getNodes().size();
        HashSet<Node> sinks = new HashSet<Node>();
        for (Node node : g) {
            pageRanks.put(node, 1.0 / m);
            if (!g.getChildren(node).isEmpty()) continue;
            sinks.add(node);
        }
        do {
            maxDiff = 0.0;
            HashMap<Node, Double> pageRanks_tmp = new HashMap<Node, Double>();
            for (Node node : g) {
                double sum = 0.0;
                for (Node node2 : g.getParents(node)) {
                    sum += (Double)pageRanks.get(node2) / (double)g.getChildren(node2).size();
                }
                for (Node node3 : sinks) {
                    sum += (Double)pageRanks.get(node3) / m;
                }
                pageRanks_tmp.put(node, (1.0 - dampingFactor) / m + dampingFactor * sum);
                maxDiff = Math.max(maxDiff, Math.abs((Double)pageRanks.get(node) - (Double)pageRanks_tmp.get(node)));
            }
            pageRanks = pageRanks_tmp;
        } while (maxDiff > precision);
        if (!archivePageRank.containsKey(g)) {
            archivePageRank.put(g, new HashMap());
        }
        if (!archivePageRank.get(g).containsKey(dampingFactor)) {
            archivePageRank.get(g).put(dampingFactor, new HashMap());
        }
        archivePageRank.get(g).get(dampingFactor).put(precision, pageRanks);
        return (Double)pageRanks.get(n);
    }

    public static Double hitsRank(Graph<? extends Node> g, Node n, double precision, boolean getAuth) {
        double maxDiff;
        if (getAuth) {
            if (archiveHITSAuthRank.containsKey(g) && archiveHITSAuthRank.get(g).containsKey(precision)) {
                return archiveHITSAuthRank.get(g).get(precision).get(n);
            }
        } else if (archiveHITSHubRank.containsKey(g) && archiveHITSHubRank.get(g).containsKey(precision)) {
            return archiveHITSHubRank.get(g).get(precision).get(n);
        }
        HashMap<Node, Double> auth = new HashMap<Node, Double>();
        HashMap<Node, Double> hub = new HashMap<Node, Double>();
        for (Node node : g) {
            auth.put(node, 1.0);
            hub.put(node, 1.0);
        }
        do {
            double sum;
            maxDiff = 0.0;
            double norm = 0.0;
            HashMap<Node, Double> auth_tmp = new HashMap<Node, Double>();
            for (Node node : g) {
                sum = 0.0;
                for (Node node2 : g.getParents(node)) {
                    sum += ((Double)hub.get(node2)).doubleValue();
                }
                auth_tmp.put(node, sum);
                norm += Math.pow(sum, 2.0);
            }
            norm = Math.sqrt(norm);
            for (Node node : g) {
                auth_tmp.put(node, (Double)auth_tmp.get(node) / norm);
                maxDiff = Math.max(maxDiff, Math.abs((Double)auth.get(node) - (Double)auth_tmp.get(node)));
            }
            norm = 0.0;
            HashMap<Node, Double> hub_tmp = new HashMap<Node, Double>();
            for (Node node : g) {
                sum = 0.0;
                for (Node node3 : g.getChildren(node)) {
                    sum += ((Double)auth.get(node3)).doubleValue();
                }
                hub_tmp.put(node, sum);
                norm += Math.pow(sum, 2.0);
            }
            norm = Math.sqrt(norm);
            for (Node node : g) {
                hub_tmp.put(node, (Double)hub_tmp.get(node) / norm);
                maxDiff = Math.max(maxDiff, Math.abs((Double)hub.get(node) - (Double)hub_tmp.get(node)));
            }
            auth = auth_tmp;
            hub = hub_tmp;
        } while (maxDiff > precision);
        if (!archiveHITSHubRank.containsKey(g)) {
            archiveHITSHubRank.put(g, new HashMap());
        }
        archiveHITSHubRank.get(g).put(precision, hub);
        if (!archiveHITSAuthRank.containsKey(g)) {
            archiveHITSAuthRank.put(g, new HashMap());
        }
        archiveHITSAuthRank.get(g).put(precision, auth);
        return getAuth ? (Double)auth.get(n) : (Double)hub.get(n);
    }

    public static ComplexNumber[] eigenvalues(Graph<? extends Node> g) {
        Matrix m = g.getAdjacencyMatrix();
        EigenvalueDecomposition ed = new EigenvalueDecomposition(m.getJamaMatrix());
        ComplexNumber[] result = new ComplexNumber[ed.getRealEigenvalues().length];
        for (int i = 0; i < ed.getImagEigenvalues().length; ++i) {
            result[i] = new ComplexNumber(ed.getRealEigenvalues()[i], ed.getImagEigenvalues()[i]);
        }
        return result;
    }

    public static boolean isIsomorphic(Graph<? extends Node> g1, Graph<? extends Node> g2) {
        MapTools mapTools = new MapTools();
        for (Map isomorphism : mapTools.allBijections(new HashSet<Node>(g1.getNodes()), new HashSet<Node>(g2.getNodes()))) {
            boolean isomorphic = true;
            for (Node node : g1) {
                for (Node node2 : g1.getChildren(node)) {
                    if (g2.getChildren((Node)isomorphism.get(node)).contains(isomorphism.get(node2))) continue;
                    isomorphic = false;
                    break;
                }
                if (isomorphic) continue;
                break;
            }
            if (!isomorphic) continue;
            return true;
        }
        return false;
    }

    public static <T extends Node> int undirecteddiameter(Graph<T> g) {
        int j;
        int i;
        int i2;
        HashMap<Node, Integer> node2ids = new HashMap<Node, Integer>();
        Node[] ids2Nodes = new Node[g.getNumberOfNodes()];
        int idx = 0;
        Iterator<T> iterator = g.iterator();
        while (iterator.hasNext()) {
            Node n;
            ids2Nodes[idx] = n = (Node)iterator.next();
            node2ids.put(n, idx);
            ++idx;
        }
        int[][] d = new int[g.getNumberOfNodes()][g.getNumberOfNodes()];
        for (i2 = 0; i2 < g.getNumberOfNodes(); ++i2) {
            d[i2][i2] = 0;
        }
        for (i2 = 0; i2 < g.getNumberOfNodes(); ++i2) {
            for (int j2 = i2 + 1; j2 < g.getNumberOfNodes(); ++j2) {
                if (g.areAdjacent(ids2Nodes[i2], ids2Nodes[j2]) || g.areAdjacent(ids2Nodes[j2], ids2Nodes[i2])) {
                    d[i2][j2] = 1;
                    d[j2][i2] = 1;
                    continue;
                }
                d[i2][j2] = Integer.MAX_VALUE;
                d[j2][i2] = Integer.MAX_VALUE;
            }
        }
        for (int k = 0; k < g.getNumberOfNodes(); ++k) {
            for (i = 0; i < g.getNumberOfNodes(); ++i) {
                for (j = 0; j < g.getNumberOfNodes(); ++j) {
                    if (d[i][k] >= Integer.MAX_VALUE || d[k][j] >= Integer.MAX_VALUE || d[i][k] + d[k][j] >= d[i][j]) continue;
                    d[i][j] = d[i][k] + d[k][j];
                    d[j][i] = d[i][j];
                }
            }
        }
        int maximum = 0;
        for (i = 0; i < g.getNumberOfNodes(); ++i) {
            for (j = i + 1; j < g.getNumberOfNodes(); ++j) {
                if (d[i][j] <= maximum) continue;
                maximum = d[i][j];
            }
        }
        return maximum;
    }

    public static <T extends Node> double globalclusteringcoefficient(Graph<T> g) {
        double numClosedTriplets = 0.0;
        double numTriplets = 0.0;
        for (Node a : g) {
            for (Node b : g) {
                if (b.equals(a)) continue;
                for (Node c : g) {
                    if (c.equals(a) || c.equals(b)) continue;
                    int numEdges = 0;
                    if (g.areAdjacent(a, b) || g.areAdjacent(b, a)) {
                        numEdges = (byte)(numEdges + 1);
                    }
                    if (g.areAdjacent(a, c) || g.areAdjacent(c, a)) {
                        numEdges = (byte)(numEdges + 1);
                    }
                    if (g.areAdjacent(b, c) || g.areAdjacent(c, b)) {
                        numEdges = (byte)(numEdges + 1);
                    }
                    if (numEdges >= 2) {
                        numTriplets += 0.16666666666666666;
                    }
                    if (numEdges != 3) continue;
                    numClosedTriplets += 0.16666666666666666;
                }
            }
        }
        return numClosedTriplets / numTriplets;
    }

    public static <T extends Node> Collection<List<T>> enumerateChordlessCircuits(Graph<T> g) {
        HashSet<List<T>> ccircuits = new HashSet<List<T>>();
        HashSet<UndirectedEdge<Node>> visitedLEdges = new HashSet<UndirectedEdge<Node>>();
        Stack<Pair> stack = new Stack<Pair>();
        for (Node v_init : g.getNodes()) {
            LinkedList<Node> p_init = new LinkedList<Node>();
            p_init.add(v_init);
            stack.push(new Pair(p_init, (Object)v_init));
            while (!stack.isEmpty()) {
                Pair elem = (Pair)stack.pop();
                List p = (List)elem.getFirst();
                Node vk = (Node)elem.getSecond();
                Node vkm1 = (Node)p.get(p.size() - 1);
                visitedLEdges.add(new UndirectedEdge<Node>(vkm1, vk));
                if (g.contains(new DirectedEdge<Node>(vkm1, vk)) && !g.contains(new DirectedEdge<Node>(vk, vkm1))) {
                    ccircuits.add(p);
                    continue;
                }
                Stack<Node> n = new Stack<Node>();
                for (Node w : g.getChildren(vkm1)) {
                    if (g.getChildren(w).contains(vkm1)) continue;
                    n.push(w);
                }
                while (!n.isEmpty()) {
                    Node v = (Node)n.pop();
                    if (visitedLEdges.contains(new UndirectedEdge<Node>(vkm1, v))) continue;
                    boolean noChord = true;
                    for (Node x : p) {
                        if (x.equals(vkm1)) continue;
                        if (g.getChildren(x).contains(v)) {
                            noChord = false;
                            break;
                        }
                        if (x.equals(vk) || !g.getChildren(v).contains(x)) continue;
                        noChord = false;
                        break;
                    }
                    if (!noChord) continue;
                    LinkedList<Node> p_current = new LinkedList<Node>();
                    p_current.addAll(p);
                    p_current.add(v);
                    stack.push(new Pair(p_current, (Object)vk));
                }
            }
        }
        return ccircuits;
    }

    public static <T extends Node> Map<T, Double> betweennessCentralityNormalised(Graph<T> graph) {
        HashMap<Node, Double> result = new HashMap<Node, Double>();
        for (Node node : graph) {
            result.put(node, 0.0);
        }
        LinkedList<Node> q = new LinkedList<Node>();
        HashMap pred = new HashMap();
        HashMap<Node, Integer> dist = new HashMap<Node, Integer>();
        LinkedList paths = new LinkedList();
        for (Node node : graph) {
            pred.clear();
            dist.clear();
            q.add(node);
            dist.put(node, 0);
            while (!q.isEmpty()) {
                Node node2 = (Node)q.poll();
                for (Node node3 : graph.getChildren(node2)) {
                    if (dist.containsKey(node3)) {
                        if ((Integer)dist.get(node3) != (Integer)dist.get(node2) + 1) continue;
                        ((Set)pred.get(node3)).add(node2);
                        continue;
                    }
                    dist.put(node3, (Integer)dist.get(node2) + 1);
                    pred.put(node3, new HashSet());
                    ((Set)pred.get(node3)).add(node2);
                    q.add(node3);
                }
            }
            for (Node node2 : pred.keySet()) {
                List path = new LinkedList<Node>();
                path.add(node2);
                paths.add(path);
                while (!paths.isEmpty()) {
                    path = (List)paths.poll();
                    if (path.get(0) == node) {
                        for (Node node3 : path) {
                            if (node3 == node || node3 == node2) continue;
                            result.put(node3, (Double)result.get(node3) + 1.0);
                        }
                        continue;
                    }
                    for (Node node3 : (Set)pred.get(path.get(0))) {
                        LinkedList<Node> newPath = new LinkedList<Node>(path);
                        newPath.add(0, node3);
                        paths.add(0, newPath);
                    }
                }
            }
        }
        double min = Double.MAX_VALUE;
        double max = 0.0;
        for (Node node : result.keySet()) {
            if ((Double)result.get(node) < min) {
                min = (Double)result.get(node);
            }
            if (!((Double)result.get(node) > max)) continue;
            max = (Double)result.get(node);
        }
        if (max == min) {
            return result;
        }
        for (Node node : result.keySet()) {
            result.put(node, ((Double)result.get(node) - min) / (max - min));
        }
        return result;
    }
}

