/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.analysis;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.sf.tweety.commons.BeliefSet;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.util.SetTools;
import net.sf.tweety.logics.commons.analysis.MusEnumerator;

public abstract class AbstractMusEnumerator<S extends Formula>
implements MusEnumerator<S> {
    @Override
    public abstract Collection<Collection<S>> minimalInconsistentSubsets(Collection<S> var1);

    @Override
    public Set<Set<S>> minimalCorrectionSubsets(Collection<S> formulas) {
        Collection<Collection<S>> mis = this.minimalInconsistentSubsets(formulas);
        HashSet<HashSet<S>> mi_sets = new HashSet<HashSet<S>>();
        for (Collection<S> m : mis) {
            mi_sets.add(new HashSet<S>(m));
        }
        SetTools settools = new SetTools();
        Set md_sets = settools.irreducibleHittingSets(mi_sets);
        return md_sets;
    }

    @Override
    public Collection<Collection<S>> maximalConsistentSubsets(Collection<S> formulas) {
        Set<Set<S>> md_sets = this.minimalCorrectionSubsets(formulas);
        HashSet<Collection<S>> result = new HashSet<Collection<S>>();
        for (Collection collection : md_sets) {
            HashSet<S> tmp = new HashSet<S>(formulas);
            tmp.removeAll(collection);
            result.add(tmp);
        }
        return result;
    }

    @Override
    public boolean isConsistent(BeliefSet<S, ?> beliefSet) {
        return this.isConsistent((Collection<S>)beliefSet);
    }

    @Override
    public boolean isConsistent(S formula) {
        HashSet<S> c = new HashSet<S>();
        c.add(formula);
        return this.isConsistent((Collection<S>)c);
    }

    @Override
    public boolean isConsistent(Collection<S> formulas) {
        return this.minimalInconsistentSubsets(formulas).isEmpty();
    }

    @Override
    public Collection<Collection<S>> getMiComponents(Collection<S> formulas) {
        boolean changed;
        LinkedList<Collection<S>> comp = new LinkedList<Collection<S>>(this.minimalInconsistentSubsets(formulas));
        block0: do {
            changed = false;
            for (int i = 0; i < comp.size(); ++i) {
                for (int j = i + 1; j < comp.size(); ++j) {
                    if (Collections.disjoint((Collection)comp.get(i), (Collection)comp.get(j))) continue;
                    changed = true;
                    ((Collection)comp.get(i)).addAll((Collection)comp.get(j));
                    comp.remove(j);
                    break;
                }
                if (changed) continue block0;
            }
        } while (changed);
        return comp;
    }
}

