/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.analysis;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.logics.commons.analysis.BeliefSetInconsistencyMeasure;
import net.sf.tweety.logics.commons.analysis.MusEnumerator;
import net.sf.tweety.math.GeneralMathException;
import net.sf.tweety.math.equation.Inequation;
import net.sf.tweety.math.opt.problem.ConstraintSatisfactionProblem;
import net.sf.tweety.math.opt.problem.OptimizationProblem;
import net.sf.tweety.math.opt.solver.Solver;
import net.sf.tweety.math.term.BinaryVariable;
import net.sf.tweety.math.term.IntegerConstant;
import net.sf.tweety.math.term.Product;
import net.sf.tweety.math.term.Term;

public class CcInconsistencyMeasure<S extends Formula>
extends BeliefSetInconsistencyMeasure<S> {
    private MusEnumerator<S> enumerator;
    private Solver solver;

    public CcInconsistencyMeasure(MusEnumerator<S> enumerator, Solver solver) {
        this.enumerator = enumerator;
        this.solver = solver;
    }

    @Override
    public Double inconsistencyMeasure(Collection<S> formulas) {
        Collection<Collection<S>> mises = this.enumerator.minimalInconsistentSubsets(formulas);
        if (mises.isEmpty()) {
            return 0.0;
        }
        HashMap<Formula, Object> f2v = new HashMap<Formula, Object>();
        HashMap<Object, Formula> v2f = new HashMap<Object, Formula>();
        int idx = 0;
        for (Formula f : formulas) {
            BinaryVariable v = new BinaryVariable("X" + idx++);
            f2v.put(f, v);
            v2f.put(v, f);
        }
        HashMap<Collection, BinaryVariable> m2v = new HashMap<Collection, BinaryVariable>();
        HashMap<BinaryVariable, Collection> v2m = new HashMap<BinaryVariable, Collection>();
        idx = 0;
        for (Collection collection : mises) {
            Object v = new BinaryVariable("Y" + idx++);
            m2v.put(collection, (BinaryVariable)v);
            v2m.put((BinaryVariable)v, collection);
        }
        BinaryVariable target = null;
        for (Object v : v2m.keySet()) {
            if (target == null) {
                target = v;
                continue;
            }
            target = target.add((Term)v);
        }
        OptimizationProblem optimizationProblem = new OptimizationProblem(1);
        optimizationProblem.setTargetFunction((Term)target);
        for (Formula formula : formulas) {
            Term left = null;
            for (Collection<S> mis : mises) {
                if (!mis.contains(formula)) continue;
                if (left == null) {
                    left = (Term)m2v.get(mis);
                    continue;
                }
                left = left.add((Term)m2v.get(mis));
            }
            if (left == null) continue;
            optimizationProblem.add((Object)new Inequation(left, (Term)new IntegerConstant(1), 1));
        }
        for (Collection collection : mises) {
            Product left2 = new IntegerConstant(-collection.size()).mult((Term)m2v.get(collection));
            Product left3 = new IntegerConstant(-1).mult((Term)m2v.get(collection));
            for (Formula f : collection) {
                left2 = left2.add((Term)f2v.get(f));
                left3 = left3.add((Term)f2v.get(f));
            }
            optimizationProblem.add((Object)new Inequation((Term)left2, (Term)new IntegerConstant(0), 3));
            optimizationProblem.add((Object)new Inequation((Term)left3, (Term)new IntegerConstant(collection.size() - 1), 1));
        }
        try {
            Map result = this.solver.solve((ConstraintSatisfactionProblem)optimizationProblem);
            return optimizationProblem.getTargetFunction().replaceAllTerms(result).doubleValue();
        }
        catch (GeneralMathException e) {
            throw new RuntimeException(e);
        }
    }
}

