/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.logics.commons.analysis.BeliefSetInconsistencyMeasure;
import net.sf.tweety.logics.commons.analysis.MusEnumerator;
import net.sf.tweety.math.GeneralMathException;
import net.sf.tweety.math.equation.Equation;
import net.sf.tweety.math.equation.Inequation;
import net.sf.tweety.math.func.FractionSequenceFunction;
import net.sf.tweety.math.func.SimpleFunction;
import net.sf.tweety.math.opt.problem.ConstraintSatisfactionProblem;
import net.sf.tweety.math.opt.problem.OptimizationProblem;
import net.sf.tweety.math.opt.solver.Solver;
import net.sf.tweety.math.term.BinaryVariable;
import net.sf.tweety.math.term.FloatConstant;
import net.sf.tweety.math.term.IntegerConstant;
import net.sf.tweety.math.term.Product;
import net.sf.tweety.math.term.Term;
import net.sf.tweety.math.term.Variable;

public class CspInconsistencyMeasure<S extends Formula>
extends BeliefSetInconsistencyMeasure<S> {
    private MusEnumerator<S> enumerator;
    private Solver solver;
    private SimpleFunction<Double, Double> measureFunction;

    public CspInconsistencyMeasure(SimpleFunction<Double, Double> measureFunction, MusEnumerator<S> enumerator, Solver solver) {
        this.measureFunction = measureFunction;
        this.enumerator = enumerator;
        this.solver = solver;
    }

    public CspInconsistencyMeasure(MusEnumerator<S> enumerator, Solver solver) {
        this((SimpleFunction<Double, Double>)new FractionSequenceFunction(), enumerator, solver);
    }

    @Override
    public Double inconsistencyMeasure(Collection<S> formulas) {
        int i;
        int i2;
        Collection<Collection<S>> mises = this.enumerator.minimalInconsistentSubsets(formulas);
        if (mises.isEmpty()) {
            return 0.0;
        }
        HashMap f2v = new HashMap();
        HashMap<BinaryVariable, Formula> v2f = new HashMap<BinaryVariable, Formula>();
        int idx = 0;
        for (Formula f : formulas) {
            ArrayList<BinaryVariable> vars = new ArrayList<BinaryVariable>();
            for (i2 = 0; i2 < mises.size(); ++i2) {
                BinaryVariable v = new BinaryVariable("X" + idx + "_" + i2);
                v2f.put(v, f);
                vars.add(v);
            }
            ++idx;
            f2v.put(f, vars);
        }
        HashMap<Collection<S>, Object> m2v = new HashMap<Collection<S>, Object>();
        HashMap<BinaryVariable, Collection<S>> v2m = new HashMap<BinaryVariable, Collection<S>>();
        ArrayList p2v = new ArrayList();
        for (i2 = 0; i2 < mises.size(); ++i2) {
            p2v.add(new HashSet());
        }
        idx = 0;
        for (Collection<S> mis : mises) {
            ArrayList vars = new ArrayList();
            for (int i3 = 0; i3 < mises.size(); ++i3) {
                BinaryVariable v = new BinaryVariable("Y" + idx + "_" + i3);
                v2m.put(v, mis);
                vars.add(v);
                ((Collection)p2v.get(i3)).add(v);
            }
            ++idx;
            m2v.put(mis, vars);
        }
        Product target = null;
        for (int i4 = 0; i4 < mises.size(); ++i4) {
            for (Variable v : (Collection)p2v.get(i4)) {
                if (target == null) {
                    target = new FloatConstant(((Double)this.measureFunction.eval((Object)(i4 + 1))).doubleValue()).mult((Term)v);
                    continue;
                }
                target = target.add((Term)new FloatConstant(((Double)this.measureFunction.eval((Object)(i4 + 1))).doubleValue()).mult((Term)v));
            }
        }
        OptimizationProblem problem = new OptimizationProblem(1);
        problem.setTargetFunction(target);
        for (i = 0; i < mises.size(); ++i) {
            for (Formula f : formulas) {
                Term left = null;
                for (Collection<S> mis : mises) {
                    if (!mis.contains(f)) continue;
                    if (left == null) {
                        left = (Term)((List)m2v.get(mis)).get(i);
                        continue;
                    }
                    left = left.add((Term)((List)m2v.get(mis)).get(i));
                }
                if (left == null) continue;
                problem.add((Object)new Inequation(left, (Term)new IntegerConstant(1), 1));
            }
        }
        for (i = 0; i < mises.size(); ++i) {
            for (Collection<S> mis : mises) {
                Product left2 = new IntegerConstant(-mis.size()).mult((Term)((List)m2v.get(mis)).get(i));
                Product left3 = new IntegerConstant(-1).mult((Term)((List)m2v.get(mis)).get(i));
                for (Formula f : mis) {
                    left2 = left2.add((Term)((List)f2v.get(f)).get(i));
                    left3 = left3.add((Term)((List)f2v.get(f)).get(i));
                }
                problem.add((Object)new Inequation((Term)left2, (Term)new IntegerConstant(0), 3));
                problem.add((Object)new Inequation((Term)left3, (Term)new IntegerConstant(mis.size() - 1), 1));
            }
        }
        for (Collection<S> mis : mises) {
            Variable sum = null;
            for (Variable v : (List)m2v.get(mis)) {
                if (sum == null) {
                    sum = v;
                    continue;
                }
                sum = sum.add((Term)v);
            }
            problem.add((Object)new Equation((Term)sum, (Term)new IntegerConstant(1)));
        }
        for (int i5 = 0; i5 < mises.size() - 1; ++i5) {
            Variable left = null;
            for (Variable v : (Collection)p2v.get(i5)) {
                if (left == null) {
                    left = v;
                    continue;
                }
                left = left.add((Term)v);
            }
            for (Variable v : (Collection)p2v.get(i5 + 1)) {
                if (left == null) {
                    left = new FloatConstant(-1.0f).mult((Term)v);
                    continue;
                }
                left = left.minus((Term)v);
            }
            problem.add((Object)new Inequation((Term)left, (Term)new IntegerConstant(0), 3));
        }
        try {
            Map result = this.solver.solve((ConstraintSatisfactionProblem)problem);
            return problem.getTargetFunction().replaceAllTerms(result).doubleValue();
        }
        catch (GeneralMathException e) {
            throw new RuntimeException(e);
        }
    }
}

