/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.analysis;

import java.util.Collection;
import net.sf.tweety.commons.BeliefBase;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.Interpretation;
import net.sf.tweety.commons.InterpretationIterator;
import net.sf.tweety.commons.analysis.InterpretationDistance;
import net.sf.tweety.logics.commons.analysis.BeliefSetInconsistencyMeasure;

public class DHitInconsistencyMeasure<T extends Interpretation<B, S>, B extends BeliefBase, S extends Formula>
extends BeliefSetInconsistencyMeasure<S> {
    private InterpretationDistance<T, B, S> distance;
    private InterpretationIterator<S, B, T> it;

    public DHitInconsistencyMeasure(InterpretationDistance<T, B, S> distance, InterpretationIterator<S, B, T> it) {
        this.distance = distance;
        this.it = it;
    }

    @Override
    public Double inconsistencyMeasure(Collection<S> formulas) {
        double val = Double.POSITIVE_INFINITY;
        this.it = this.it.reset(formulas);
        while (this.it.hasNext()) {
            Interpretation i = this.it.next();
            double tmp = 0.0;
            for (Formula f : formulas) {
                if (!(this.distance.distance(f, i) > 0.0)) continue;
                tmp += 1.0;
            }
            if (!(tmp < val)) continue;
            val = tmp;
        }
        return val;
    }
}

