/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.analysis;

import java.util.Collection;
import java.util.HashSet;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.util.MathTools;
import net.sf.tweety.logics.commons.analysis.BeliefSetInconsistencyMeasure;
import net.sf.tweety.logics.commons.analysis.MusEnumerator;
import net.sf.tweety.math.func.SimpleFunction;

public class DfInconsistencyMeasure<S extends Formula>
extends BeliefSetInconsistencyMeasure<S> {
    private MusEnumerator<S> enumerator;
    private SimpleFunction<double[], Double> measureFunction;

    public DfInconsistencyMeasure(SimpleFunction<double[], Double> measureFunction, MusEnumerator<S> enumerator) {
        this.measureFunction = measureFunction;
        this.enumerator = enumerator;
    }

    @Override
    public Double inconsistencyMeasure(Collection<S> formulas) {
        Collection<Collection<S>> mus = this.enumerator.minimalInconsistentSubsets(formulas);
        double[] vcard = new double[formulas.size()];
        double[] conflictRatios = new double[formulas.size()];
        for (Collection<S> mu : mus) {
            int n = mu.size() - 1;
            vcard[n] = vcard[n] + 1.0;
        }
        double[] cn = this.getConsistentSetCounts(new HashSet(), formulas, mus, formulas.size());
        for (int i = 0; i < formulas.size(); ++i) {
            conflictRatios[i] = vcard[i] + cn[i] == 0.0 ? 0.0 : vcard[i] / (vcard[i] + cn[i]);
        }
        return (Double)this.measureFunction.eval((Object)conflictRatios);
    }

    private double[] getConsistentSetCounts(Collection<S> inFormulas, Collection<S> restFormulas, Collection<Collection<S>> mus, int card) {
        for (Collection<S> mu : mus) {
            if (!inFormulas.containsAll(mu)) continue;
            return new double[card];
        }
        HashSet<S> joint = new HashSet<S>();
        joint.addAll(inFormulas);
        joint.addAll(restFormulas);
        boolean c = true;
        for (Collection<S> mu : mus) {
            c = true;
            if (!joint.containsAll(mu)) continue;
            c = false;
            break;
        }
        if (c) {
            double[] result = new double[card];
            if (!inFormulas.isEmpty()) {
                result[inFormulas.size() - 1] = 1.0;
            }
            for (int i = 1; i <= restFormulas.size(); ++i) {
                int cidx = i + inFormulas.size() - 1;
                result[cidx] = MathTools.binomial((Integer)restFormulas.size(), (Integer)i).intValue();
            }
            return result;
        }
        Formula f = (Formula)restFormulas.iterator().next();
        HashSet<S> newRest = new HashSet<S>(restFormulas);
        newRest.remove(f);
        double[] d1 = this.getConsistentSetCounts(inFormulas, newRest, mus, card);
        HashSet<S> newIn = new HashSet<S>(inFormulas);
        newIn.add(f);
        double[] d2 = this.getConsistentSetCounts(newIn, newRest, mus, card);
        double[] result = new double[card];
        for (int i = 0; i < card; ++i) {
            result[i] = d1[i] + d2[i];
        }
        return result;
    }

    public String toString() {
        return "df";
    }
}

