/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.analysis;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.tweety.commons.BeliefBase;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.Interpretation;
import net.sf.tweety.commons.InterpretationIterator;
import net.sf.tweety.logics.commons.analysis.BeliefSetInconsistencyMeasure;
import net.sf.tweety.math.GeneralMathException;
import net.sf.tweety.math.equation.Equation;
import net.sf.tweety.math.equation.Inequation;
import net.sf.tweety.math.opt.problem.ConstraintSatisfactionProblem;
import net.sf.tweety.math.opt.problem.OptimizationProblem;
import net.sf.tweety.math.opt.solver.Solver;
import net.sf.tweety.math.term.FloatConstant;
import net.sf.tweety.math.term.FloatVariable;
import net.sf.tweety.math.term.IntegerConstant;
import net.sf.tweety.math.term.Term;

public class EtaInconsistencyMeasure<B extends BeliefBase, S extends Formula>
extends BeliefSetInconsistencyMeasure<S> {
    private InterpretationIterator<S, B, ? extends Interpretation<B, S>> it;

    public EtaInconsistencyMeasure(InterpretationIterator<S, B, ? extends Interpretation<B, S>> it) {
        this.it = it;
    }

    @Override
    public Double inconsistencyMeasure(Collection<S> formulas) {
        this.it = this.it.reset(formulas);
        OptimizationProblem problem = new OptimizationProblem(1);
        FloatVariable eta = new FloatVariable("eta");
        problem.add((Object)new Inequation((Term)eta, (Term)new FloatConstant(0.0f), 3));
        problem.add((Object)new Inequation((Term)eta, (Term)new FloatConstant(1.0f), 1));
        problem.setTargetFunction((Term)eta);
        HashMap<Object, FloatVariable> worlds2vars = new HashMap<Object, FloatVariable>();
        int i = 0;
        FloatVariable normConstraint = null;
        this.it = this.it.reset();
        while (this.it.hasNext()) {
            Interpretation interpretation = this.it.next();
            FloatVariable var = new FloatVariable("w" + i++);
            problem.add((Object)new Inequation((Term)var, (Term)new FloatConstant(0.0f), 3));
            problem.add((Object)new Inequation((Term)var, (Term)new FloatConstant(1.0f), 1));
            worlds2vars.put(interpretation, var);
            if (normConstraint == null) {
                normConstraint = var;
                continue;
            }
            normConstraint = normConstraint.add((Term)var);
        }
        problem.add((Object)new Equation(normConstraint, (Term)new IntegerConstant(1)));
        for (Formula f : formulas) {
            Term leftTerm = null;
            this.it = this.it.reset();
            while (this.it.hasNext()) {
                Interpretation interpretation = this.it.next();
                if (!interpretation.satisfies(f)) continue;
                if (leftTerm == null) {
                    leftTerm = (Term)worlds2vars.get(interpretation);
                    continue;
                }
                leftTerm = leftTerm.add((Term)worlds2vars.get(interpretation));
            }
            if (leftTerm == null) {
                problem.add((Object)new Inequation((Term)eta, (Term)new FloatConstant(0.0f), 1));
                continue;
            }
            problem.add((Object)new Inequation((Term)leftTerm.minus((Term)eta), (Term)new FloatConstant(0.0f), 3));
        }
        try {
            Map solution = Solver.getDefaultLinearSolver().solve((ConstraintSatisfactionProblem)problem);
            return 1.0 - ((Term)solution.get(eta)).doubleValue();
        }
        catch (GeneralMathException e) {
            return 1.0;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public String toString() {
        return "eta";
    }
}

