/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.analysis;

import java.util.Collection;
import java.util.HashSet;
import net.sf.tweety.commons.BeliefBase;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.Interpretation;
import net.sf.tweety.commons.InterpretationIterator;
import net.sf.tweety.logics.commons.analysis.BeliefSetInconsistencyMeasure;

public class HsInconsistencyMeasure<B extends BeliefBase, S extends Formula>
extends BeliefSetInconsistencyMeasure<S> {
    private InterpretationIterator<S, B, ? extends Interpretation<B, S>> it;

    public HsInconsistencyMeasure(InterpretationIterator<S, B, ? extends Interpretation<B, S>> it) {
        this.it = it;
    }

    @Override
    public Double inconsistencyMeasure(Collection<S> formulas) {
        this.it = this.it.reset(formulas);
        if (formulas.isEmpty()) {
            return 0.0;
        }
        for (int card = 1; card <= formulas.size(); ++card) {
            Collection<Interpretation<B, S>> hittingSet = this.getHittingSet(formulas, card, new HashSet<Interpretation<B, S>>());
            if (hittingSet == null) continue;
            return (double)hittingSet.size() - 1.0;
        }
        return Double.POSITIVE_INFINITY;
    }

    private Collection<Interpretation<B, S>> getHittingSet(Collection<S> formulas, int card, Collection<Interpretation<B, S>> interpretations) {
        InterpretationIterator it = this.it.reset();
        while (it.hasNext()) {
            Interpretation i = it.next();
            if (interpretations.contains(i)) continue;
            HashSet<Interpretation<B, S>> newInts = new HashSet<Interpretation<B, S>>(interpretations);
            newInts.add(i);
            if (card > 1) {
                Collection<Interpretation<B, S>> cand = this.getHittingSet(formulas, card - 1, newInts);
                if (cand == null) continue;
                return cand;
            }
            if (!this.isHittingSet(formulas, newInts)) continue;
            return newInts;
        }
        return null;
    }

    private boolean isHittingSet(Collection<S> formulas, Collection<Interpretation<B, S>> candidate) {
        for (Formula f : formulas) {
            boolean sat = false;
            for (Interpretation<B, S> i : candidate) {
                if (!i.satisfies(f)) continue;
                sat = true;
                break;
            }
            if (sat) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "HS";
    }
}

