/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.analysis;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.util.SetTools;
import net.sf.tweety.logics.commons.analysis.BeliefSetInconsistencyMeasure;
import net.sf.tweety.logics.commons.analysis.MusEnumerator;

public class MaInconsistencyMeasure<S extends Formula>
extends BeliefSetInconsistencyMeasure<S> {
    private MusEnumerator<S> enumerator;

    public MaInconsistencyMeasure(MusEnumerator<S> enumerator) {
        this.enumerator = enumerator;
    }

    @Override
    public Double inconsistencyMeasure(Collection<S> formulas) {
        Double scs = 0.0;
        for (Formula f : formulas) {
            if (this.enumerator.isConsistent(f)) continue;
            Double d = scs;
            scs = scs + 1.0;
        }
        return scs + this.numMaxConsistentFormulas(this.enumerator.minimalInconsistentSubsets(formulas)) - 1.0;
    }

    private double numMaxConsistentFormulas(Collection<Collection<S>> muses) {
        SetTools setTools = new SetTools();
        HashSet<HashSet<S>> mSets = new HashSet<HashSet<S>>();
        for (Collection<S> mus : muses) {
            mSets.add(new HashSet<S>(mus));
        }
        Set hSets = setTools.permutations(mSets);
        double result = 0.0;
        for (Set h1 : hSets) {
            boolean nonMin = false;
            for (Set h2 : hSets) {
                if (h1 == h2 || !h1.containsAll(h2)) continue;
                nonMin = true;
                break;
            }
            if (nonMin) continue;
            result += 1.0;
        }
        return result;
    }
}

