/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.util.SetTools;
import net.sf.tweety.logics.commons.analysis.BeliefSetInconsistencyMeasure;
import net.sf.tweety.logics.commons.analysis.MusEnumerator;

public class McscInconsistencyMeasure<S extends Formula>
extends BeliefSetInconsistencyMeasure<S> {
    private MusEnumerator<S> enumerator;

    public McscInconsistencyMeasure(MusEnumerator<S> enumerator) {
        this.enumerator = enumerator;
    }

    private Set<Set<Set<S>>> getMdAnticover(List<Set<S>> md, int idx, Set<Set<Set<S>>> candidates) {
        HashSet<Set<Set<S>>> result = new HashSet<Set<Set<S>>>();
        SetTools st = new SetTools();
        if (idx < md.size() - 1) {
            HashSet<Set<Set<S>>> new_candidates = new HashSet<Set<Set<S>>>();
            for (Set<Set<S>> s : candidates) {
                new_candidates.add(s);
                HashSet<Set<S>> m = new HashSet<Set<S>>();
                m.addAll(s);
                m.add(md.get(idx));
                if (st.hasEmptyIntersection(m)) {
                    result.add(m);
                    continue;
                }
                new_candidates.add(m);
            }
            result.addAll(this.getMdAnticover(md, idx + 1, new_candidates));
        } else {
            for (Set<Set<S>> s : candidates) {
                s.add(md.get(idx));
                if (!st.hasEmptyIntersection(s)) continue;
                result.add(s);
            }
        }
        return result;
    }

    @Override
    public Double inconsistencyMeasure(Collection<S> formulas) {
        ArrayList<Set<S>> md = new ArrayList<Set<S>>(this.enumerator.minimalCorrectionSubsets(formulas));
        if (md.isEmpty()) {
            return 0.0;
        }
        HashSet<Set<Set<S>>> cand = new HashSet<Set<Set<S>>>();
        SetTools st = new SetTools();
        cand.add(new HashSet());
        Set<Set<Set<S>>> anticover = this.getMdAnticover(md, 0, cand);
        int min_union_size = Integer.MAX_VALUE;
        boolean found_finite = false;
        for (Set<Set<S>> ac : anticover) {
            int size;
            boolean ismin = true;
            for (Set<Set<S>> ac2 : anticover) {
                if (ac == ac2 || !ac.containsAll(ac2)) continue;
                ismin = false;
                break;
            }
            if (!ismin || (size = st.getUnion(ac).size()) >= min_union_size) continue;
            min_union_size = size;
            found_finite = true;
        }
        if (found_finite) {
            return min_union_size;
        }
        return Double.POSITIVE_INFINITY;
    }
}

