/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.analysis;

import java.util.Collection;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.logics.commons.analysis.BeliefSetInconsistencyMeasure;
import net.sf.tweety.logics.commons.analysis.MusEnumerator;

public class NConsInconsistencyMeasure<S extends Formula>
extends BeliefSetInconsistencyMeasure<S> {
    private MusEnumerator<S> enumerator;

    public NConsInconsistencyMeasure(MusEnumerator<S> enumerator) {
        this.enumerator = enumerator;
    }

    @Override
    public Double inconsistencyMeasure(Collection<S> formulas) {
        Collection<Collection<S>> muses = this.enumerator.minimalInconsistentSubsets(formulas);
        if (muses.isEmpty()) {
            return 0.0;
        }
        double minMus = formulas.size();
        for (Collection<S> mus : muses) {
            if (!((double)mus.size() < minMus)) continue;
            minMus = mus.size();
        }
        return (double)formulas.size() - minMus + 1.0;
    }
}

