/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.analysis;

import java.util.Collection;
import java.util.HashSet;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.logics.commons.analysis.AbstractMusEnumerator;
import net.sf.tweety.logics.commons.analysis.BeliefSetConsistencyTester;

public class NaiveMusEnumerator<S extends Formula>
extends AbstractMusEnumerator<S> {
    private BeliefSetConsistencyTester<S> tester;

    public NaiveMusEnumerator(BeliefSetConsistencyTester<S> tester) {
        this.tester = tester;
    }

    @Override
    public Collection<Collection<S>> minimalInconsistentSubsets(Collection<S> beliefSet) {
        if (this.tester.isConsistent((S)beliefSet)) {
            return new HashSet<Collection<S>>();
        }
        HashSet<Collection<S>> result = new HashSet<Collection<S>>();
        HashSet<Collection<Object>> candidates = new HashSet<Collection<Object>>();
        HashSet<Collection> tmp = new HashSet<Collection>();
        for (Formula formula : beliefSet) {
            HashSet<Formula> candidate = new HashSet<Formula>();
            candidate.add(formula);
            candidates.add(candidate);
        }
        while (!candidates.isEmpty()) {
            Collection<Collection<S>> new_candidates = new HashSet<Collection<S>>();
            for (Collection collection : candidates) {
                if (!this.tester.isConsistent((S)collection)) {
                    tmp.clear();
                    boolean m = true;
                    for (Collection collection2 : result) {
                        if (collection2.containsAll(collection)) {
                            tmp.add(collection2);
                        }
                        if (!collection.containsAll(collection2)) continue;
                        m = false;
                        break;
                    }
                    result.removeAll(tmp);
                    if (!m) continue;
                    result.add(collection);
                    continue;
                }
                new_candidates.add(collection);
            }
            new_candidates = this.merge(new_candidates);
            candidates = new HashSet();
            for (Collection<S> cand : new_candidates) {
                boolean contains = false;
                for (Collection collection : result) {
                    if (!cand.containsAll(collection)) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                candidates.add(cand);
            }
        }
        return result;
    }

    private Collection<Collection<S>> merge(Collection<Collection<S>> formulas) {
        HashSet<Collection<S>> result = new HashSet<Collection<S>>();
        for (Collection<S> f1 : formulas) {
            for (Collection<S> f2 : formulas) {
                if (f1 == f2) continue;
                HashSet<S> merged = new HashSet<S>();
                merged.addAll(f1);
                merged.addAll(f2);
                result.add(merged);
            }
        }
        return result;
    }
}

