/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.analysis;

import java.util.Collection;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.util.MathTools;
import net.sf.tweety.logics.commons.analysis.MiInconsistencyMeasure;
import net.sf.tweety.logics.commons.analysis.MusEnumerator;

public class NormalizedMiInconsistencyMeasure<S extends Formula>
extends MiInconsistencyMeasure<S> {
    public NormalizedMiInconsistencyMeasure(MusEnumerator<S> enumerator) {
        super(enumerator);
    }

    @Override
    public Double inconsistencyMeasure(Collection<S> beliefSet) {
        Double value = super.inconsistencyMeasure(beliefSet);
        if (value == 0.0) {
            return value;
        }
        double normFactor = MathTools.binomial((Integer)beliefSet.size(), (Integer)new Double(Math.ceil(new Double(beliefSet.size()) / 2.0)).intValue()).intValue();
        return value / normFactor;
    }
}

