/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.analysis;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.tweety.commons.BeliefSet;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.util.MathTools;
import net.sf.tweety.commons.util.Pair;
import net.sf.tweety.commons.util.SetTools;
import net.sf.tweety.logics.commons.analysis.BeliefSetInconsistencyMeasure;
import net.sf.tweety.logics.commons.analysis.CulpabilityMeasure;

public class ShapleyCulpabilityMeasure<S extends Formula, T extends BeliefSet<S, ?>>
implements CulpabilityMeasure<S, T> {
    private BeliefSetInconsistencyMeasure<S> inconsistencyMeasure;
    private Map<Pair<T, S>, Double> archive;

    public ShapleyCulpabilityMeasure(BeliefSetInconsistencyMeasure<S> inconsistencyMeasure) {
        this.inconsistencyMeasure = inconsistencyMeasure;
        this.archive = new HashMap<Pair<T, S>, Double>();
    }

    @Override
    public Double culpabilityMeasure(T beliefSet, S formula) {
        if (this.archive.containsKey(new Pair(beliefSet, formula))) {
            return this.archive.get(new Pair(beliefSet, formula));
        }
        Set<Pair<Collection<S>, Collection<S>>> subbases = this.getSubsets(beliefSet, formula);
        Double result = 0.0;
        for (Pair<Collection<S>, Collection<S>> pair : subbases) {
            Double v1 = this.inconsistencyMeasure.inconsistencyMeasure((Collection)pair.getFirst());
            Double v2 = this.inconsistencyMeasure.inconsistencyMeasure((Collection)pair.getSecond());
            Double temp = v1 - v2;
            temp = temp * (double)MathTools.faculty((int)((Collection)pair.getSecond()).size());
            temp = temp * (double)MathTools.faculty((int)(beliefSet.size() - ((Collection)pair.getFirst()).size()));
            temp = temp / (double)MathTools.faculty((int)beliefSet.size());
            result = result + temp;
        }
        this.archive.put(new Pair(beliefSet, formula), result);
        return result;
    }

    private Set<Pair<Collection<S>, Collection<S>>> getSubsets(T kb, S f) {
        HashSet<Pair<Collection<S>, Collection<S>>> result = new HashSet<Pair<Collection<S>, Collection<S>>>();
        Set subsets = new SetTools().subsets(kb);
        for (Set subset : subsets) {
            if (subset.contains(f)) continue;
            Pair pair = new Pair();
            HashSet<S> first = new HashSet<S>(subset);
            first.add(f);
            pair.setFirst(first);
            pair.setSecond(new HashSet(subset));
            result.add(pair);
        }
        return result;
    }
}

