/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.analysis.streams;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.streams.FormulaStream;
import net.sf.tweety.logics.commons.analysis.streams.InconsistencyListener;
import net.sf.tweety.logics.commons.analysis.streams.InconsistencyMeasurementProcess;
import net.sf.tweety.logics.commons.analysis.streams.InconsistencyUpdateEvent;
import net.sf.tweety.logics.commons.analysis.streams.StreamBasedInconsistencyMeasure;

public class DefaultStreamBasedInconsistencyMeasure<S extends Formula>
extends StreamBasedInconsistencyMeasure<S> {
    private Class<? extends InconsistencyMeasurementProcess<S>> clazz;
    private List<InconsistencyListener> listeners = new LinkedList<InconsistencyListener>();
    private Map<String, Object> config;

    public DefaultStreamBasedInconsistencyMeasure(Class<? extends InconsistencyMeasurementProcess<S>> clazz) {
        this(clazz, new HashMap<String, Object>());
    }

    public DefaultStreamBasedInconsistencyMeasure(Class<? extends InconsistencyMeasurementProcess<S>> clazz, Map<String, Object> config) {
        this.clazz = clazz;
        this.config = config;
    }

    @Override
    public Double inconsistencyMeasure(Collection<S> formulas) {
        return null;
    }

    @Override
    public InconsistencyMeasurementProcess<S> getInconsistencyMeasureProcess(FormulaStream<S> stream) {
        try {
            InconsistencyMeasurementProcess<S> imp = this.clazz.newInstance();
            imp.init(stream, this, this.config);
            return imp;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addInconsistencyListener(InconsistencyListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeInconsistencyListener(InconsistencyListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void fireInconsistencyUpdateEvent(InconsistencyUpdateEvent evt) {
        for (InconsistencyListener listener : this.listeners) {
            listener.inconsistencyUpdateOccured(evt);
        }
    }

    public String toString() {
        return "DSBIM";
    }

    @Override
    void fireInconsistencyMeasurementStartedEvent(InconsistencyUpdateEvent evt) {
        for (InconsistencyListener listener : this.listeners) {
            listener.inconsistencyMeasurementStarted(evt);
        }
    }
}

