/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.analysis.streams;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.sf.tweety.logics.commons.analysis.streams.InconsistencyListener;
import net.sf.tweety.logics.commons.analysis.streams.InconsistencyUpdateEvent;

public class EvaluationInconsistencyListener
implements InconsistencyListener {
    private File file;
    private int maxEvents;
    private int numberOfEvents;
    private long lastMillis;
    private long cumulativeTime;
    public static double INCDEFAULTVALUE = -1.0;
    public static double TOLERANCE = -1.0;

    public EvaluationInconsistencyListener(String file, int maxEvents) {
        this.file = new File(file);
        this.maxEvents = maxEvents;
    }

    @Override
    public void inconsistencyUpdateOccured(InconsistencyUpdateEvent evt) {
        ++this.numberOfEvents;
        String log = this.numberOfEvents + ";";
        log = log + (System.currentTimeMillis() - this.lastMillis) + ";";
        this.cumulativeTime += System.currentTimeMillis() - this.lastMillis;
        this.lastMillis = System.currentTimeMillis();
        log = log + this.cumulativeTime + ";";
        log = log + evt.measure.toString() + ";";
        log = log + evt.process.toString() + ";";
        log = log + evt.f.toString() + ";";
        log = log + evt.inconsistencyValue + "\n";
        if (TOLERANCE != -1.0 && evt.inconsistencyValue >= INCDEFAULTVALUE - TOLERANCE && evt.inconsistencyValue <= INCDEFAULTVALUE + TOLERANCE) {
            evt.process.abort();
            log = log + "END\n";
        }
        if (this.numberOfEvents + 1 > this.maxEvents) {
            evt.process.abort();
            log = log + "END\n";
        }
        this.writeToDisk(log);
    }

    private void writeToDisk(String log) {
        try {
            FileWriter writer = new FileWriter(this.file, true);
            writer.append(log);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void inconsistencyMeasurementStarted(InconsistencyUpdateEvent evt) {
        this.numberOfEvents = 0;
        this.writeToDisk("BEGIN\n");
        this.lastMillis = System.currentTimeMillis();
        this.cumulativeTime = 0L;
    }
}

