/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.analysis.streams;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.streams.FormulaStream;
import net.sf.tweety.logics.commons.analysis.streams.InconsistencyUpdateEvent;
import net.sf.tweety.logics.commons.analysis.streams.StreamBasedInconsistencyMeasure;

public abstract class InconsistencyMeasurementProcess<S extends Formula>
extends Thread {
    public static final String CONFIG_TIMEOUT = "config_timeout";
    private FormulaStream<S> stream;
    private boolean abort;
    private Double iValue;
    private StreamBasedInconsistencyMeasure<S> parent;
    private long timeout;

    @Override
    public void run() {
        this.parent.fireInconsistencyMeasurementStartedEvent(new InconsistencyUpdateEvent(this.parent, this, -1.0, null));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        while (!this.abort && this.stream.hasNext()) {
            Formula f = this.stream.next();
            if (this.timeout == -1L) {
                this.iValue = this.update(f);
            } else {
                try {
                    Future<Double> future = executor.submit(new UpdateCallee(this, this, f));
                    this.iValue = future.get(this.timeout, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.abort = true;
                    this.iValue = -1.0;
                }
            }
            this.parent.fireInconsistencyUpdateEvent(new InconsistencyUpdateEvent(this.parent, this, this.iValue, f));
        }
        executor.shutdownNow();
    }

    protected void init(FormulaStream<S> stream, StreamBasedInconsistencyMeasure<S> parent, Map<String, Object> config) {
        this.abort = false;
        this.stream = stream;
        this.iValue = 0.0;
        this.parent = parent;
        this.timeout = config.containsKey(CONFIG_TIMEOUT) ? (Long)config.get(CONFIG_TIMEOUT) : -1L;
        this.init(config);
    }

    protected abstract void init(Map<String, Object> var1);

    protected abstract double update(S var1);

    @Override
    public abstract String toString();

    public void abort() {
        this.abort = true;
    }

    public Double getInconsistencyValue() {
        return this.iValue;
    }

    private static class UpdateCallee
    implements Callable<Double> {
        InconsistencyMeasurementProcess<S> imp;
        S formula;
        final /* synthetic */ InconsistencyMeasurementProcess this$0;

        public UpdateCallee(InconsistencyMeasurementProcess<S> imp, S formula) {
            this.this$0 = var1_1;
            this.imp = imp;
            this.formula = formula;
        }

        @Override
        public Double call() throws Exception {
            return this.imp.update(this.formula);
        }
    }
}

