/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.analysis.streams;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.logics.commons.analysis.BeliefSetInconsistencyMeasure;
import net.sf.tweety.logics.commons.analysis.streams.InconsistencyMeasurementProcess;
import net.sf.tweety.math.func.BinaryFunction;
import net.sf.tweety.math.func.MaxFunction;

public abstract class WindowInconsistencyMeasurementProcess<S extends Formula>
extends InconsistencyMeasurementProcess<S> {
    private BeliefSetInconsistencyMeasure<S> measure;
    private int windowsize;
    private Queue<S> formulas;
    private double previousValue;
    private BinaryFunction<Double, Double, Double> agg = null;
    private String name;
    public static final String CONFIG_MEASURE = "config_measure";
    public static final String CONFIG_WINDOWSIZE = "config_windowsize";
    public static final String CONFIG_AGGREGATIONFUNCTION = "config_aggregationfunction";
    public static final String CONFIG_NAME = "config_name";

    @Override
    protected void init(Map<String, Object> config) {
        this.formulas = new LinkedList<S>();
        if (!config.containsKey(CONFIG_MEASURE)) {
            throw new RuntimeException("Key \"CONFIG_MEASURE\" expected for configuration of WindowInconsistencyMeasurementProcess");
        }
        this.measure = (BeliefSetInconsistencyMeasure)config.get(CONFIG_MEASURE);
        this.windowsize = config.containsKey(CONFIG_WINDOWSIZE) ? (Integer)config.get(CONFIG_WINDOWSIZE) : -1;
        this.agg = config.containsKey(CONFIG_AGGREGATIONFUNCTION) ? (BinaryFunction)config.get(CONFIG_AGGREGATIONFUNCTION) : new MaxFunction();
        this.name = config.containsKey(CONFIG_NAME) ? (String)config.get(CONFIG_NAME) : "";
        this.previousValue = 0.0;
    }

    @Override
    protected double update(S formula) {
        if (this.windowsize != -1 && this.formulas.size() >= this.windowsize) {
            this.formulas.poll();
        }
        this.formulas.remove(formula);
        this.formulas.add(formula);
        double oldVal = this.previousValue;
        double newVal = this.measure.inconsistencyMeasure((Collection<S>)this.formulas);
        this.previousValue = (Double)this.agg.eval((Object)oldVal, (Object)newVal);
        return this.previousValue;
    }

    @Override
    public String toString() {
        return "WIMP" + this.name + "-" + this.measure.toString();
    }
}

