/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.syntax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import net.sf.tweety.commons.Signature;
import net.sf.tweety.logics.commons.LogicalSymbols;
import net.sf.tweety.logics.commons.syntax.ComplexLogicalFormulaAdapter;
import net.sf.tweety.logics.commons.syntax.Predicate;
import net.sf.tweety.logics.commons.syntax.interfaces.AssociativeFormula;
import net.sf.tweety.logics.commons.syntax.interfaces.Atom;
import net.sf.tweety.logics.commons.syntax.interfaces.ComplexLogicalFormula;
import net.sf.tweety.logics.commons.syntax.interfaces.SimpleLogicalFormula;
import net.sf.tweety.logics.commons.syntax.interfaces.Term;

public class AssociativeFormulaSupport<T extends SimpleLogicalFormula>
extends ComplexLogicalFormulaAdapter
implements AssociativeFormula<T> {
    private AssociativeSupportBridge bridge;
    private List<T> formulas = new LinkedList<T>();

    public AssociativeFormulaSupport(AssociativeSupportBridge bridge) {
        this.bridge = bridge;
    }

    public AssociativeFormulaSupport(AssociativeFormulaSupport<T> other) {
        this.bridge = other.bridge;
        for (SimpleLogicalFormula formula : other.formulas) {
            SimpleLogicalFormula castformula = formula.clone();
            this.formulas.add(castformula);
        }
    }

    public Collection<T> copyHelper(Collection<T> collection) {
        ArrayList<SimpleLogicalFormula> reval = new ArrayList<SimpleLogicalFormula>();
        for (SimpleLogicalFormula formula : collection) {
            SimpleLogicalFormula cloned = formula.clone();
            reval.add(cloned);
        }
        return reval;
    }

    @Override
    public List<T> getFormulas() {
        return new LinkedList<T>(this.formulas);
    }

    @Override
    public <C extends SimpleLogicalFormula> Set<C> getFormulas(Class<C> cls) {
        HashSet<SimpleLogicalFormula> reval = new HashSet<SimpleLogicalFormula>();
        for (SimpleLogicalFormula rf : this.formulas) {
            if (!rf.getClass().equals(cls)) continue;
            SimpleLogicalFormula cast = rf;
            reval.add(cast);
        }
        return reval;
    }

    @Override
    public Set<? extends Atom> getAtoms() {
        HashSet<? extends Atom> reval = new HashSet<Atom>();
        for (SimpleLogicalFormula formula : this.formulas) {
            reval.addAll(formula.getAtoms());
        }
        return reval;
    }

    @Override
    public Set<? extends Predicate> getPredicates() {
        HashSet<? extends Predicate> predicates = new HashSet<Predicate>();
        for (SimpleLogicalFormula f : this) {
            predicates.addAll(f.getPredicates());
        }
        return predicates;
    }

    public Signature getSignature() {
        Signature signature = this.bridge.createEmptySignature();
        for (SimpleLogicalFormula formula : this) {
            signature.addSignature(formula.getSignature());
        }
        return signature;
    }

    public String toString() {
        if (this.isEmpty()) {
            return this.bridge.getEmptySymbol();
        }
        Object s = "";
        boolean isFirst = true;
        for (SimpleLogicalFormula f : this) {
            if (isFirst) {
                isFirst = false;
            } else {
                s = (String)s + this.bridge.getOperatorSymbol();
            }
            if (f instanceof AssociativeFormula && ((AssociativeFormula)f).size() > 1) {
                s = (String)s + LogicalSymbols.PARENTHESES_LEFT() + f.toString() + LogicalSymbols.PARENTHESES_RIGHT();
                continue;
            }
            s = (String)s + f.toString();
        }
        return s;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof AssociativeFormulaSupport) {
            AssociativeFormulaSupport cast = (AssociativeFormulaSupport)other;
            return cast.formulas.equals(this.formulas);
        }
        if (other instanceof List) {
            return this.formulas.equals(other);
        }
        if (other instanceof Set) {
            LinkedList temp = new LinkedList((Set)other);
            return this.formulas.equals(temp);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.formulas.hashCode();
    }

    @Override
    public AssociativeFormulaSupport<T> clone() {
        return new AssociativeFormulaSupport<T>(this);
    }

    private ComplexLogicalFormula checkedFormulaType(T formula) {
        if (!(formula instanceof ComplexLogicalFormula)) {
            throw new IllegalArgumentException("The formula '" + formula.toString() + "' is no complex formula.");
        }
        return (ComplexLogicalFormula)formula;
    }

    @Override
    public Set<Term<?>> getTerms() {
        HashSet reval = new HashSet();
        for (SimpleLogicalFormula f : this) {
            reval.addAll(this.checkedFormulaType(f).getTerms());
        }
        return reval;
    }

    @Override
    public <C extends Term<?>> Set<C> getTerms(Class<C> cls) {
        HashSet reval = new HashSet();
        for (SimpleLogicalFormula f : this) {
            reval.addAll(this.checkedFormulaType(f).getTerms(cls));
        }
        return reval;
    }

    @Override
    public ComplexLogicalFormula substitute(Term<?> v, Term<?> t) throws IllegalArgumentException {
        HashSet<ComplexLogicalFormula> substitutedFormulas = new HashSet<ComplexLogicalFormula>();
        for (SimpleLogicalFormula formula : this) {
            ComplexLogicalFormula substitudedFormula = this.checkedFormulaType(formula).substitute(v, t);
            substitutedFormulas.add(substitudedFormula);
        }
        AssociativeFormula formula = this.bridge.createEmptyFormula();
        formula.addAll(substitutedFormulas);
        return (ComplexLogicalFormula)((Object)formula);
    }

    @Override
    public boolean isWellFormed() {
        if (this.size() < 2) {
            return false;
        }
        for (SimpleLogicalFormula formula : this) {
            if (!this.checkedFormulaType(formula).isWellFormed()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(T e) {
        return this.formulas.add(e);
    }

    @Override
    public boolean add(T ... formulas) {
        boolean result = true;
        for (T f : formulas) {
            boolean sub = this.add(f);
            result = result && sub;
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.formulas.addAll(c);
    }

    @Override
    public void clear() {
        this.formulas.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.formulas.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.formulas.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.formulas.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.formulas.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.formulas.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.formulas.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.formulas.retainAll(c);
    }

    @Override
    public int size() {
        return this.formulas.size();
    }

    @Override
    public Object[] toArray() {
        return this.formulas.toArray();
    }

    @Override
    public <C> C[] toArray(C[] a) {
        return this.formulas.toArray(a);
    }

    @Override
    public Class<? extends Predicate> getPredicateCls() {
        return null;
    }

    @Override
    public void add(int index, T element) {
        this.formulas.add(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.formulas.addAll(index, c);
    }

    @Override
    public T get(int index) {
        return (T)((SimpleLogicalFormula)this.formulas.get(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.formulas.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.formulas.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.formulas.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.formulas.listIterator(index);
    }

    @Override
    public T remove(int index) {
        return (T)((SimpleLogicalFormula)this.formulas.remove(index));
    }

    @Override
    public T set(int index, T element) {
        return (T)((SimpleLogicalFormula)this.formulas.set(index, element));
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.formulas.subList(fromIndex, toIndex);
    }

    public static interface AssociativeSupportBridge {
        public <T extends SimpleLogicalFormula> AssociativeFormula<T> createEmptyFormula();

        public Signature createEmptySignature();

        public String getOperatorSymbol();

        public String getEmptySymbol();
    }
}

