/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.syntax;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.tweety.logics.commons.syntax.Constant;
import net.sf.tweety.logics.commons.syntax.Variable;
import net.sf.tweety.logics.commons.syntax.interfaces.ComplexLogicalFormula;
import net.sf.tweety.logics.commons.syntax.interfaces.Term;

public abstract class ComplexLogicalFormulaAdapter
implements ComplexLogicalFormula {
    @Override
    public ComplexLogicalFormula substitute(Map<? extends Term<?>, ? extends Term<?>> map) throws IllegalArgumentException {
        ComplexLogicalFormula f = this;
        for (Term<?> v : map.keySet()) {
            f = f.substitute(v, map.get(v));
        }
        return f;
    }

    @Override
    public ComplexLogicalFormula exchange(Term<?> v, Term<?> t) throws IllegalArgumentException {
        if (!v.getSort().equals(t.getSort())) {
            throw new IllegalArgumentException("Terms '" + v + "' and '" + t + "' are of different sorts.");
        }
        Constant temp = new Constant("$TEMP$", v.getSort());
        ComplexLogicalFormula rf = this.substitute(v, temp);
        rf = rf.substitute(t, v);
        rf = rf.substitute(temp, t);
        v.getSort().remove(temp);
        return rf;
    }

    @Override
    public <C extends Term<?>> Set<C> getTerms(Class<C> cls) {
        HashSet<Term> reval = new HashSet<Term>();
        for (Term term : this.getTerms()) {
            if (!term.getClass().equals(cls)) continue;
            Term castTerm = term;
            reval.add(castTerm);
        }
        return reval;
    }

    @Override
    public <C extends Term<?>> boolean containsTermsOfType(Class<C> cls) {
        return !this.getTerms(cls).isEmpty();
    }

    @Override
    public boolean isGround() {
        return this.getTerms(Variable.class).isEmpty();
    }

    @Override
    public boolean isWellFormed() {
        return true;
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public abstract ComplexLogicalFormula clone();
}

