/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.syntax;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.tweety.commons.util.Pair;
import net.sf.tweety.logics.commons.syntax.Functor;
import net.sf.tweety.logics.commons.syntax.TermAdapter;
import net.sf.tweety.logics.commons.syntax.interfaces.Term;

public class FunctionalTerm
extends TermAdapter<Pair<Functor, List<Term<?>>>> {
    public FunctionalTerm(Functor functor, Term<?> ... terms) {
        super(new Pair((Object)functor, Arrays.asList(terms)), functor.getTargetSort());
    }

    public FunctionalTerm(Functor functor, List<Term<?>> arguments) {
        super(new Pair((Object)functor, arguments), functor.getTargetSort());
    }

    public FunctionalTerm(FunctionalTerm other) {
        this(((Functor)((Pair)other.value).getFirst()).clone(), new LinkedList((Collection)((Pair)other.value).getSecond()));
    }

    public Functor getFunctor() {
        return (Functor)((Pair)this.value).getFirst();
    }

    public List<Term<?>> getArguments() {
        return Collections.unmodifiableList((List)((Pair)this.value).getSecond());
    }

    public boolean isComplete() {
        return ((List)((Pair)this.value).getSecond()).size() == ((Functor)((Pair)this.value).getFirst()).getArity();
    }

    public FunctionalTerm(Functor functor) {
        this(functor, new ArrayList());
    }

    public FunctionalTerm addArgument(Term<?> term) throws IllegalArgumentException {
        if (this.getArguments().size() == this.getFunctor().getArity()) {
            throw new IllegalArgumentException("No more arguments expected.");
        }
        if (!this.getFunctor().getArgumentTypes().get(this.getArguments().size()).equals(term.getSort())) {
            throw new IllegalArgumentException("The sort \"" + term.getSort() + "\" of the given term does not correspond to the expected sort \"" + this.getFunctor().getArgumentTypes().get(this.getArguments().size()) + "\".");
        }
        ((List)((Pair)this.value).getSecond()).add(term);
        return this;
    }

    @Override
    public Set<Term<?>> getTerms() {
        Set<Term<?>> reval = super.getTerms();
        for (Term<?> t : this.getArguments()) {
            reval.addAll(t.getTerms());
        }
        return reval;
    }

    @Override
    public <C extends Term<?>> Set<C> getTerms(Class<C> cls) {
        Set<C> reval = super.getTerms(cls);
        for (Term<?> t : this.getArguments()) {
            reval.addAll(t.getTerms(cls));
        }
        return reval;
    }

    @Override
    public Term<?> substitute(Term<?> v, Term<?> t) throws IllegalArgumentException {
        if (!v.getSort().equals(t.getSort())) {
            throw new IllegalArgumentException("Cannot replace " + v + " by " + t + " because " + v + " is of sort " + v.getSort() + " while " + t + " is of sort " + t.getSort() + ".");
        }
        if (v.equals(this)) {
            return t;
        }
        return this;
    }

    @Override
    public String toString() {
        Object output = this.getFunctor().getName();
        if (this.getArguments().size() == 0) {
            return output;
        }
        output = (String)output + "(";
        output = (String)output + this.getArguments().get(0);
        for (int i = 1; i < this.getArguments().size(); ++i) {
            output = (String)output + "," + this.getArguments().get(i);
        }
        output = (String)output + ")";
        return output;
    }

    @Override
    public FunctionalTerm clone() {
        return new FunctionalTerm(this);
    }
}

