/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.syntax;

import java.util.HashSet;
import java.util.Set;
import net.sf.tweety.logics.commons.syntax.Functor;
import net.sf.tweety.logics.commons.syntax.Predicate;
import net.sf.tweety.logics.commons.syntax.RelationalFormula;
import net.sf.tweety.logics.commons.syntax.Variable;
import net.sf.tweety.logics.commons.syntax.interfaces.Atom;
import net.sf.tweety.logics.commons.syntax.interfaces.Term;

public class QuantifiedFormulaSupport<T extends RelationalFormula> {
    private T innerFormula;
    private Set<Variable> quantifier_variables;

    public QuantifiedFormulaSupport(T formula, Set<Variable> variables) {
        this.innerFormula = formula;
        this.quantifier_variables = variables;
    }

    public T getFormula() {
        return this.innerFormula;
    }

    public Set<Variable> getQuantifierVariables() {
        return new HashSet<Variable>(this.quantifier_variables);
    }

    public void setFormula(T formula) {
        this.innerFormula = formula;
    }

    public void setQuantifierVariables(Set<Variable> variables) {
        this.quantifier_variables = variables;
    }

    public boolean isClosed() {
        return this.innerFormula.isClosed(this.quantifier_variables);
    }

    public boolean isClosed(Set<Variable> boundVariables) {
        HashSet<Variable> variables = new HashSet<Variable>(this.quantifier_variables);
        variables.addAll(boundVariables);
        return this.innerFormula.isClosed(variables);
    }

    public boolean containsQuantifier() {
        return true;
    }

    public boolean isWellBound() {
        return this.innerFormula.isWellBound(this.quantifier_variables);
    }

    public boolean isWellBound(Set<Variable> boundVariables) {
        HashSet<Variable> intersection = new HashSet<Variable>(this.quantifier_variables);
        intersection.retainAll(boundVariables);
        if (!intersection.isEmpty()) {
            return false;
        }
        HashSet<Variable> variables = new HashSet<Variable>(this.quantifier_variables);
        variables.addAll(boundVariables);
        return this.innerFormula.isWellBound(variables);
    }

    public Set<? extends Predicate> getPredicates() {
        return this.innerFormula.getPredicates();
    }

    public Set<Functor> getFunctors() {
        return ((RelationalFormula)this.innerFormula).getFunctors();
    }

    public Set<? extends Atom> getAtoms() {
        return ((RelationalFormula)this.innerFormula).getAtoms();
    }

    public Set<Variable> getUnboundVariables() {
        Set variables = this.innerFormula.getUnboundVariables();
        variables.removeAll(this.quantifier_variables);
        return variables;
    }

    public boolean isDnf() {
        return false;
    }

    public boolean isLiteral() {
        return false;
    }

    public Set<Term<?>> getTerms() {
        return this.innerFormula.getTerms();
    }

    public <C extends Term<?>> Set<C> getTerms(Class<C> cls) {
        return this.innerFormula.getTerms(cls);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.innerFormula == null ? 0 : this.innerFormula.hashCode());
        result = 31 * result + (this.quantifier_variables == null ? 0 : this.quantifier_variables.hashCode());
        return result;
    }
}

