/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.syntax;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.tweety.commons.util.MapTools;
import net.sf.tweety.logics.commons.syntax.Constant;
import net.sf.tweety.logics.commons.syntax.FunctionalTerm;
import net.sf.tweety.logics.commons.syntax.Functor;
import net.sf.tweety.logics.commons.syntax.Predicate;
import net.sf.tweety.logics.commons.syntax.Sort;
import net.sf.tweety.logics.commons.syntax.Variable;
import net.sf.tweety.logics.commons.syntax.interfaces.Atom;
import net.sf.tweety.logics.commons.syntax.interfaces.ClassicalFormula;
import net.sf.tweety.logics.commons.syntax.interfaces.ComplexLogicalFormula;
import net.sf.tweety.logics.commons.syntax.interfaces.Conjunctable;
import net.sf.tweety.logics.commons.syntax.interfaces.Disjunctable;
import net.sf.tweety.logics.commons.syntax.interfaces.QuantifiedFormula;
import net.sf.tweety.logics.commons.syntax.interfaces.Term;
import net.sf.tweety.math.probability.Probability;

public abstract class RelationalFormula
implements ClassicalFormula,
QuantifiedFormula {
    @Override
    public RelationalFormula getFormula() {
        return this;
    }

    @Override
    public abstract Set<? extends Atom> getAtoms();

    public abstract Set<Functor> getFunctors();

    @Override
    public Class<? extends Predicate> getPredicateCls() {
        return Predicate.class;
    }

    @Override
    public abstract RelationalFormula substitute(Term<?> var1, Term<?> var2) throws IllegalArgumentException;

    @Override
    public RelationalFormula substitute(Map<? extends Term<?>, ? extends Term<?>> map) throws IllegalArgumentException {
        ComplexLogicalFormula f = this;
        for (Term<?> v : map.keySet()) {
            f = f.substitute((Term)v, (Term)map.get(v));
        }
        return f;
    }

    @Override
    public RelationalFormula exchange(Term<?> v, Term<?> t) throws IllegalArgumentException {
        if (!v.getSort().equals(t.getSort())) {
            throw new IllegalArgumentException("Terms '" + v + "' and '" + t + "' are of different sorts.");
        }
        Constant temp = new Constant("$TEMP$", v.getSort());
        ComplexLogicalFormula rf = this.substitute((Term)v, (Term)temp);
        rf = ((RelationalFormula)rf).substitute((Term)t, (Term)v);
        rf = ((RelationalFormula)rf).substitute((Term)temp, (Term)t);
        v.getSort().remove(temp);
        return rf;
    }

    public Set<Map<Variable, Term<?>>> allSubstitutions(Collection<? extends Term<?>> terms) throws IllegalArgumentException {
        Set variables = this.getUnboundVariables();
        HashMap sorts_variables = new HashMap();
        for (Variable v : variables) {
            if (!sorts_variables.containsKey(v.getSort())) {
                sorts_variables.put(v.getSort(), new HashSet());
            }
            ((Set)sorts_variables.get(v.getSort())).add(v);
        }
        Map<Sort, Set<Term<?>>> sorts_terms = Sort.sortTerms(terms);
        HashMap relations = new HashMap();
        for (Sort s : sorts_variables.keySet()) {
            if (!sorts_terms.containsKey(s)) {
                throw new IllegalArgumentException("There is no term of sort " + s + " to substitute.");
            }
            relations.put((Set)sorts_variables.get(s), sorts_terms.get(s));
        }
        return new MapTools().allMaps(relations);
    }

    public Set<RelationalFormula> allGroundInstances(Set<Constant> constants) throws IllegalArgumentException {
        Set<Map<Variable, Term<?>>> maps = this.allSubstitutions(constants);
        HashSet<RelationalFormula> result = new HashSet<RelationalFormula>();
        for (Map<Variable, Term<?>> map : maps) {
            result.add((RelationalFormula)this.substitute(map));
        }
        return result;
    }

    public double getSatisfactionRatio() {
        return this.complement().getUniformProbability().doubleValue() / this.getUniformProbability().doubleValue();
    }

    @Override
    public abstract Probability getUniformProbability();

    @Override
    public boolean isGround() {
        return this.getTerms(Variable.class).isEmpty();
    }

    @Override
    public boolean isWellFormed() {
        int i;
        for (Variable variable : this.getTerms(Variable.class)) {
            for (Variable variable2 : this.getTerms(Variable.class)) {
                if (!variable.get().equals(variable2.get()) || variable.getSort().equals(variable2.getSort())) continue;
                return false;
            }
        }
        for (Constant constant : this.getTerms(Constant.class)) {
            for (Constant constant2 : this.getTerms(Constant.class)) {
                if (!constant.get().equals(constant2.get()) || constant.getSort().equals(constant2.getSort())) continue;
                return false;
            }
        }
        for (Predicate predicate : this.getPredicates()) {
            for (Predicate predicate2 : this.getPredicates()) {
                if (!predicate.getName().equals(predicate2.getName())) continue;
                if (predicate.getArity() != predicate2.getArity()) {
                    return false;
                }
                for (i = 0; i < predicate.getArity(); ++i) {
                    if (predicate.getArgumentTypes().get(i).equals(predicate2.getArgumentTypes().get(i))) continue;
                    return false;
                }
            }
        }
        for (Functor functor : this.getFunctors()) {
            if (functor.getArity() == 0) {
                return false;
            }
            for (Functor functor2 : this.getFunctors()) {
                if (!functor.getName().equals(functor2.getName())) continue;
                if (!functor.getTargetSort().equals(functor2.getTargetSort())) {
                    return false;
                }
                if (functor.getArity() != functor2.getArity()) {
                    return false;
                }
                for (i = 0; i < functor.getArity(); ++i) {
                    if (functor.getArgumentTypes().get(i).equals(functor2.getArgumentTypes().get(i))) continue;
                    return false;
                }
            }
        }
        for (Atom atom : this.getAtoms()) {
            if (atom.isComplete()) continue;
            return false;
        }
        for (FunctionalTerm functionalTerm : this.getTerms(FunctionalTerm.class)) {
            if (functionalTerm.isComplete()) continue;
            return false;
        }
        return this.isWellBound();
    }

    @Override
    public <C extends Term<?>> boolean containsTermsOfType(Class<C> cls) {
        return !this.getTerms(cls).isEmpty();
    }

    @Override
    public abstract RelationalFormula complement();

    @Override
    public abstract Conjunctable combineWithOr(Disjunctable var1);

    @Override
    public abstract Disjunctable combineWithAnd(Conjunctable var1);

    public abstract String toString();

    @Override
    public abstract RelationalFormula clone();
}

