/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.syntax;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.tweety.logics.commons.syntax.Constant;
import net.sf.tweety.logics.commons.syntax.StringTerm;
import net.sf.tweety.logics.commons.syntax.Variable;
import net.sf.tweety.logics.commons.syntax.interfaces.LogicStructure;
import net.sf.tweety.logics.commons.syntax.interfaces.Term;

public class Sort
implements LogicStructure {
    private String name;
    private Set<Constant> constants;
    private Set<Variable> variables;
    public static final Sort THING = new Sort("Thing");
    public static final Sort ANY = new Sort("_Any");

    public Sort(String name) {
        this.constants = new HashSet<Constant>();
        this.variables = new HashSet<Variable>();
        this.name = name;
    }

    public Sort(String name, Set<Constant> constants) {
        this(name);
        this.constants.addAll(constants);
    }

    public Sort(Sort other) {
        this.name = other.name;
        this.constants = new HashSet<Constant>(other.constants);
        this.variables = new HashSet<Variable>(other.variables);
    }

    public static Map<Sort, Set<Term<?>>> sortTerms(Collection<? extends Term<?>> terms) {
        HashMap sorts = new HashMap();
        for (Term<?> t : terms) {
            if (!sorts.containsKey(t.getSort())) {
                sorts.put(t.getSort(), new HashSet());
            }
            ((Set)sorts.get(t.getSort())).add(t);
        }
        return sorts;
    }

    public void add(Term<?> term) {
        if (term instanceof Constant) {
            this.constants.add((Constant)term);
        } else if (term instanceof Variable) {
            this.variables.add((Variable)term);
        }
    }

    public boolean remove(Term<?> term) {
        if (term instanceof Constant) {
            return this.constants.remove(term);
        }
        if (term instanceof Variable) {
            return this.variables.remove(term);
        }
        throw new IllegalArgumentException("Term has to be either variable or constant.");
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == ANY || obj == ANY) {
            return true;
        }
        Sort other = (Sort)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public Set<Term<?>> getTerms() {
        HashSet reval = new HashSet();
        reval.addAll(this.constants);
        reval.addAll(this.variables);
        return reval;
    }

    @Override
    public <C extends Term<?>> Set<C> getTerms(Class<C> cls) {
        Set<StringTerm> reval = null;
        reval = cls == Constant.class ? Collections.unmodifiableSet(this.constants) : (cls == Variable.class ? Collections.unmodifiableSet(this.variables) : new HashSet<Constant>());
        return reval;
    }

    @Override
    public <C extends Term<?>> boolean containsTermsOfType(Class<C> cls) {
        return !this.getTerms(cls).isEmpty();
    }

    public Sort clone() {
        return new Sort(this);
    }
}

