/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.syntax;

import java.util.HashSet;
import java.util.Set;
import net.sf.tweety.logics.commons.syntax.Sort;
import net.sf.tweety.logics.commons.syntax.interfaces.Term;

public abstract class TermAdapter<T>
implements Term<T> {
    protected T value;
    private Sort sort;

    public TermAdapter(T value) {
        this(value, Sort.THING);
    }

    public TermAdapter(T value, Sort sort) {
        this.sort = sort;
        this.set(value);
        sort.add(this);
    }

    @Override
    public Set<Term<?>> getTerms() {
        HashSet reval = new HashSet();
        reval.add(this);
        return reval;
    }

    @Override
    public <C extends Term<?>> Set<C> getTerms(Class<C> cls) {
        HashSet<TermAdapter> reval = new HashSet<TermAdapter>();
        if (this.getClass().equals(cls)) {
            TermAdapter castThis = this;
            reval.add(castThis);
        }
        return reval;
    }

    @Override
    public <C extends Term<?>> boolean containsTermsOfType(Class<C> cls) {
        return !this.getTerms(cls).isEmpty();
    }

    @Override
    public Term<?> substitute(Term<?> v, Term<?> t) throws IllegalArgumentException {
        if (!v.getSort().equals(t.getSort())) {
            throw new IllegalArgumentException("Cannot replace " + v + " by " + t + " because " + v + " is of sort " + v.getSort() + " while " + t + " is of sort " + t.getSort() + ".");
        }
        if (v.equals(this)) {
            return t;
        }
        return this;
    }

    @Override
    public Sort getSort() {
        return this.sort;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sort == null ? 0 : this.sort.hashCode());
        if (this.get() != null) {
            result += this.get().hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Term other = (Term)obj;
        if (this.sort == null ? other.getSort() != null : !this.sort.equals(other.getSort())) {
            return false;
        }
        return this.get().equals(other.get());
    }

    @Override
    public abstract TermAdapter<?> clone();

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void set(T value) {
        this.value = value;
    }

    @Override
    public T get() {
        return this.value;
    }
}

