/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.commons.syntax;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.tweety.logics.commons.syntax.Sort;
import net.sf.tweety.logics.commons.syntax.interfaces.TypedStructure;

public abstract class TypedStructureAdapter
implements TypedStructure,
Comparable<TypedStructureAdapter> {
    private String name;
    private List<Sort> arguments = new ArrayList<Sort>();
    private int arity;

    public TypedStructureAdapter() {
    }

    public TypedStructureAdapter(String name) {
        this.name = name;
    }

    public TypedStructureAdapter(String name, int arity) {
        this(name);
        for (int i = 0; i < arity; ++i) {
            this.arguments.add(Sort.THING);
        }
    }

    public TypedStructureAdapter(String name, List<Sort> arguments) {
        this(name);
        this.arguments.addAll(arguments);
        this.arity = arguments.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getArity() {
        return this.arguments.size();
    }

    @Override
    public List<Sort> getArgumentTypes() {
        return Collections.unmodifiableList(this.arguments);
    }

    @Override
    public void addArgumentType(Sort argType) {
        this.arguments.add(argType);
    }

    @Override
    public Sort removeArgumentType(int index) {
        return this.arguments.remove(index);
    }

    @Override
    public boolean removeArgumentType(Sort argType) {
        return this.arguments.remove(argType);
    }

    @Override
    public boolean isTyped() {
        for (Sort s : this.arguments) {
            if (s == Sort.THING) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isComplete() {
        return this.arity == this.arguments.size();
    }

    public String toString() {
        Object s = this.name;
        Iterator<Sort> it = this.arguments.iterator();
        if (!it.hasNext()) {
            return s;
        }
        s = (String)s + "(" + it.next();
        while (it.hasNext()) {
            s = (String)s + "," + it.next();
        }
        s = (String)s + ")";
        return s;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arguments == null ? 0 : this.arguments.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypedStructureAdapter other = (TypedStructureAdapter)obj;
        if (this.arguments == null ? other.arguments != null : !this.arguments.equals(other.arguments)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    protected List<Sort> copyArgumentTypes() {
        LinkedList<Sort> argumentTypes = new LinkedList<Sort>();
        for (Sort sort : this.getArgumentTypes()) {
            argumentTypes.add(sort.clone());
        }
        return argumentTypes;
    }

    @Override
    public abstract TypedStructure clone();

    @Override
    public int compareTo(TypedStructureAdapter o) {
        return Collator.getInstance().compare(this.name, o.name);
    }
}

