/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.lp.asp.analysis;

import java.util.HashSet;
import java.util.Set;
import net.sf.tweety.commons.BeliefBase;
import net.sf.tweety.commons.util.IncreasingSubsetIterator;
import net.sf.tweety.logics.commons.analysis.InconsistencyMeasure;
import net.sf.tweety.logics.fol.semantics.HerbrandBase;
import net.sf.tweety.logics.fol.syntax.FolAtom;
import net.sf.tweety.logics.fol.syntax.FolSignature;
import net.sf.tweety.lp.asp.reasoner.ASPSolver;
import net.sf.tweety.lp.asp.semantics.AnswerSet;
import net.sf.tweety.lp.asp.syntax.ASPAtom;
import net.sf.tweety.lp.asp.syntax.ASPRule;
import net.sf.tweety.lp.asp.syntax.Program;
import net.sf.tweety.lp.asp.syntax.StrictNegation;

public class PmInconsistencyMeasure
implements InconsistencyMeasure<Program> {
    private ASPSolver solver;

    public PmInconsistencyMeasure(ASPSolver solver) {
        this.solver = solver;
    }

    public Double inconsistencyMeasure(Program beliefBase) {
        if (!beliefBase.isGround()) {
            throw new RuntimeException("Measure only defined for ground programs.");
        }
        if (((AnswerSet)this.solver.getModel((BeliefBase)beliefBase)).size() > 0) {
            return 0.0;
        }
        int min = Integer.MAX_VALUE;
        IncreasingSubsetIterator it_del = new IncreasingSubsetIterator((Set)((Object)beliefBase));
        HashSet<ASPRule> allFacts = new HashSet<ASPRule>();
        FolSignature sig = beliefBase.getMinimalSignature();
        for (FolAtom a : new HerbrandBase(sig).getAtoms()) {
            allFacts.add(new ASPRule(new ASPAtom(a)));
            allFacts.add(new ASPRule(new StrictNegation(new ASPAtom(a))));
        }
        while (it_del.hasNext()) {
            IncreasingSubsetIterator it_add = new IncreasingSubsetIterator(allFacts);
            Set del = it_del.next();
            if (del.size() > min) {
                return min;
            }
            while (it_add.hasNext()) {
                Set add = it_add.next();
                if (del.size() + add.size() >= min) continue;
                Program p = beliefBase.clone();
                p.removeAll(del);
                p.addAll(add);
                if (((AnswerSet)this.solver.getModel((BeliefBase)p)).size() <= 0) continue;
                min = del.size() + add.size();
            }
        }
        return min;
    }
}

