/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.lp.asp.analysis;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.sf.tweety.commons.BeliefBase;
import net.sf.tweety.commons.util.DefaultSubsetIterator;
import net.sf.tweety.commons.util.SetTools;
import net.sf.tweety.logics.commons.analysis.InconsistencyMeasure;
import net.sf.tweety.logics.fol.semantics.HerbrandBase;
import net.sf.tweety.logics.fol.syntax.FolAtom;
import net.sf.tweety.logics.fol.syntax.FolSignature;
import net.sf.tweety.lp.asp.reasoner.ASPSolver;
import net.sf.tweety.lp.asp.semantics.AnswerSet;
import net.sf.tweety.lp.asp.syntax.ASPAtom;
import net.sf.tweety.lp.asp.syntax.ASPLiteral;
import net.sf.tweety.lp.asp.syntax.Program;
import net.sf.tweety.lp.asp.syntax.StrictNegation;

public class SdInconsistencyMeasure
implements InconsistencyMeasure<Program> {
    private ASPSolver solver;

    public SdInconsistencyMeasure(ASPSolver solver) {
        this.solver = solver;
    }

    private boolean isConsistent(Collection<ASPLiteral> c) {
        for (ASPLiteral l : c) {
            if (!(l instanceof StrictNegation) || !c.contains(((StrictNegation)l).getAtom())) continue;
            return false;
        }
        return true;
    }

    public Double inconsistencyMeasure(Program beliefBase) {
        if (!beliefBase.isGround()) {
            throw new RuntimeException("Measure only defined for ground programs.");
        }
        try {
            if (((AnswerSet)this.solver.getModel((BeliefBase)beliefBase)).size() > 0) {
                return 0.0;
            }
            HashSet<ASPLiteral> allLiterals = new HashSet<ASPLiteral>();
            FolSignature sig = beliefBase.getMinimalSignature();
            for (FolAtom a : new HerbrandBase(sig).getAtoms()) {
                allLiterals.add(new ASPAtom(a));
                allLiterals.add(new StrictNegation(new ASPAtom(a)));
            }
            Double result = Double.POSITIVE_INFINITY;
            DefaultSubsetIterator lit_it = new DefaultSubsetIterator(allLiterals);
            while (lit_it.hasNext()) {
                int val;
                Program p;
                Collection<AnswerSet> asl;
                Set m = lit_it.next();
                if (!this.isConsistent(m) || (asl = this.solver.getModels(p = beliefBase.reduct(m))).size() == 0 || !((double)(val = new SetTools().symmetricDifference((Collection)m, (Collection)((Object)asl.iterator().next())).size()) < result)) continue;
                result = val;
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

