/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.lp.asp.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.logics.commons.syntax.Constant;
import net.sf.tweety.logics.commons.syntax.FunctionalTerm;
import net.sf.tweety.logics.commons.syntax.Functor;
import net.sf.tweety.logics.commons.syntax.NumberTerm;
import net.sf.tweety.logics.commons.syntax.Predicate;
import net.sf.tweety.logics.commons.syntax.Variable;
import net.sf.tweety.logics.commons.syntax.interfaces.Term;
import net.sf.tweety.lp.asp.parser.ASPCore2ParserVisitor;
import net.sf.tweety.lp.asp.parser.ASTAggrElement;
import net.sf.tweety.lp.asp.parser.ASTAggrElementList;
import net.sf.tweety.lp.asp.parser.ASTAggrFunc;
import net.sf.tweety.lp.asp.parser.ASTAggregate;
import net.sf.tweety.lp.asp.parser.ASTAnswerSet;
import net.sf.tweety.lp.asp.parser.ASTAriTerm;
import net.sf.tweety.lp.asp.parser.ASTArithop;
import net.sf.tweety.lp.asp.parser.ASTBinop;
import net.sf.tweety.lp.asp.parser.ASTBody;
import net.sf.tweety.lp.asp.parser.ASTBodyList;
import net.sf.tweety.lp.asp.parser.ASTBuiltInAtom;
import net.sf.tweety.lp.asp.parser.ASTChoice;
import net.sf.tweety.lp.asp.parser.ASTChoiceElement;
import net.sf.tweety.lp.asp.parser.ASTChoiceElementList;
import net.sf.tweety.lp.asp.parser.ASTClingoMeta;
import net.sf.tweety.lp.asp.parser.ASTHead;
import net.sf.tweety.lp.asp.parser.ASTHeadElementsList;
import net.sf.tweety.lp.asp.parser.ASTID;
import net.sf.tweety.lp.asp.parser.ASTLiteral;
import net.sf.tweety.lp.asp.parser.ASTNAFLiteral;
import net.sf.tweety.lp.asp.parser.ASTNAFLiteralList;
import net.sf.tweety.lp.asp.parser.ASTNumber;
import net.sf.tweety.lp.asp.parser.ASTOpt;
import net.sf.tweety.lp.asp.parser.ASTOptElement;
import net.sf.tweety.lp.asp.parser.ASTOptElementList;
import net.sf.tweety.lp.asp.parser.ASTOptFunc;
import net.sf.tweety.lp.asp.parser.ASTProgram;
import net.sf.tweety.lp.asp.parser.ASTQuery;
import net.sf.tweety.lp.asp.parser.ASTRule;
import net.sf.tweety.lp.asp.parser.ASTRuleList;
import net.sf.tweety.lp.asp.parser.ASTString;
import net.sf.tweety.lp.asp.parser.ASTTerm;
import net.sf.tweety.lp.asp.parser.ASTTermList;
import net.sf.tweety.lp.asp.parser.ASTVar;
import net.sf.tweety.lp.asp.parser.ASTWeight;
import net.sf.tweety.lp.asp.parser.ParseException;
import net.sf.tweety.lp.asp.parser.SimpleNode;
import net.sf.tweety.lp.asp.semantics.AnswerSet;
import net.sf.tweety.lp.asp.syntax.ASPAtom;
import net.sf.tweety.lp.asp.syntax.ASPBodyElement;
import net.sf.tweety.lp.asp.syntax.ASPHead;
import net.sf.tweety.lp.asp.syntax.ASPLiteral;
import net.sf.tweety.lp.asp.syntax.ASPOperator;
import net.sf.tweety.lp.asp.syntax.ASPRule;
import net.sf.tweety.lp.asp.syntax.AggregateAtom;
import net.sf.tweety.lp.asp.syntax.AggregateElement;
import net.sf.tweety.lp.asp.syntax.ArithmeticTerm;
import net.sf.tweety.lp.asp.syntax.ComparativeAtom;
import net.sf.tweety.lp.asp.syntax.DefaultNegation;
import net.sf.tweety.lp.asp.syntax.Program;
import net.sf.tweety.lp.asp.syntax.StrictNegation;

public class InstantiateVisitor
implements ASPCore2ParserVisitor {
    private Set<Predicate> predicates_whitelist = new HashSet<Predicate>();

    @Override
    public Object visit(SimpleNode node, Object data) {
        throw new RuntimeException();
    }

    public AnswerSet visit(ASTAnswerSet node, Object data) {
        AnswerSet as = new AnswerSet();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (!(node.jjtGetChild(i) instanceof ASTLiteral)) continue;
            ASPLiteral a = this.visit((ASTLiteral)node.jjtGetChild(i), null);
            as.add((Formula)a);
        }
        return as;
    }

    public Program visit(ASTProgram node, Object data) {
        this.predicates_whitelist = new HashSet<Predicate>();
        Program p = new Program();
        try {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                if (node.jjtGetChild(i) instanceof ASTRuleList) {
                    Object rules = this.visit((ASTRuleList)node.jjtGetChild(i), null);
                    p.addAll((Collection)rules);
                    continue;
                }
                if (!(node.jjtGetChild(i) instanceof ASTQuery)) continue;
                if (!p.hasQuery()) {
                    ASPLiteral q = this.visit((ASTQuery)node.jjtGetChild(i), null);
                    p.setQuery(q);
                    continue;
                }
                throw new ParseException("Error: Multiple queries found. There can only be one query per program.");
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        p.setOutputWhitelist(this.predicates_whitelist);
        return p;
    }

    @Override
    public ASPLiteral visit(ASTQuery node, Object data) {
        ASPLiteral atom = null;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (!(node.jjtGetChild(i) instanceof ASTLiteral)) continue;
            atom = this.visit((ASTLiteral)node.jjtGetChild(i), null);
        }
        return atom;
    }

    @Override
    public List<ASPRule> visit(ASTRuleList node, Object data) {
        ArrayList<ASPRule> elements = new ArrayList<ASPRule>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            ASPRule a;
            if (!(node.jjtGetChild(i) instanceof ASTRule) || (a = this.visit((ASTRule)node.jjtGetChild(i), null)).isEmpty()) continue;
            elements.add(a);
        }
        return elements;
    }

    @Override
    public ASPRule visit(ASTRule node, Object data) {
        ASPHead head = new ASPHead();
        Object body = new LinkedList<ASPBodyElement>();
        Term weight = null;
        Term level = null;
        Object rightTerms = new ArrayList();
        if (node.jjtGetChild(0) instanceof ASTHead) {
            head = this.visit((ASTHead)node.jjtGetChild(0), null);
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (node.jjtGetChild(i) instanceof ASTBodyList) {
                body = this.visit((ASTBodyList)node.jjtGetChild(i), null);
                continue;
            }
            if (node.jjtGetChild(i) instanceof ASTWeight) {
                rightTerms = this.visit((ASTWeight)node.jjtGetChild(i), null);
                weight = (Term)rightTerms.remove(0);
                if (!((ASTWeight)node.jjtGetChild((int)i)).hasLevel) continue;
                level = (Term)rightTerms.remove(0);
                continue;
            }
            if (!(node.jjtGetChild(i) instanceof ASTClingoMeta)) continue;
            String cm = this.visit((ASTClingoMeta)node.jjtGetChild(i), null).substring(6).trim();
            String[] s = cm.split("/");
            Predicate pw = new Predicate(s[0], Integer.parseInt(s[1].substring(0, s[1].length() - 1)));
            this.predicates_whitelist.add(pw);
        }
        ASPRule rule = new ASPRule((List<ASPBodyElement>)body, (Term<?>)weight, (Term<?>)level, (List<Term<?>>)rightTerms);
        rule.setHead(head);
        return rule;
    }

    @Override
    public ASPHead visit(ASTHead node, Object data) {
        Object head_atoms = new ArrayList<ASPLiteral>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (!(node.jjtGetChild(i) instanceof ASTHeadElementsList)) continue;
            head_atoms = this.visit((ASTHeadElementsList)node.jjtGetChild(i), null);
        }
        return new ASPHead((List<ASPLiteral>)head_atoms);
    }

    @Override
    public List<ASPLiteral> visit(ASTHeadElementsList node, Object data) {
        ArrayList<ASPLiteral> elements = new ArrayList<ASPLiteral>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (!(node.jjtGetChild(i) instanceof ASTLiteral)) continue;
            ASPLiteral a = this.visit((ASTLiteral)node.jjtGetChild(i), null);
            elements.add(a);
        }
        return elements;
    }

    @Override
    public List<ASPBodyElement> visit(ASTBodyList node, Object data) {
        ArrayList<ASPBodyElement> rule_bodies = new ArrayList<ASPBodyElement>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (!(node.jjtGetChild(i) instanceof ASTBody)) continue;
            Object rule_body = this.visit((ASTBody)node.jjtGetChild(i), null);
            rule_bodies.addAll((Collection<ASPBodyElement>)rule_body);
        }
        return rule_bodies;
    }

    @Override
    public List<ASPBodyElement> visit(ASTBody node, Object data) {
        ArrayList<ASPBodyElement> rule_body = new ArrayList<ASPBodyElement>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            ASPBodyElement l;
            if (node.jjtGetChild(i) instanceof ASTNAFLiteral) {
                l = this.visit((ASTNAFLiteral)node.jjtGetChild(i), null);
                rule_body.add(l);
                continue;
            }
            if (!(node.jjtGetChild(i) instanceof ASTAggregate)) continue;
            l = this.visit((ASTAggregate)node.jjtGetChild(i), null);
            rule_body.add(l);
        }
        return rule_body;
    }

    @Override
    public Object visit(ASTChoice node, Object data) {
        throw new UnsupportedOperationException("Choice rules are not currently supported by this parser.");
    }

    @Override
    public List<ASPRule> visit(ASTChoiceElementList node, Object data) {
        throw new UnsupportedOperationException("Choice rules are not currently supported by this parser.");
    }

    @Override
    public ASPRule visit(ASTChoiceElement node, Object data) {
        throw new UnsupportedOperationException("Choice rules are not currently supported by this parser.");
    }

    @Override
    public AggregateAtom visit(ASTAggregate node, Object data) {
        Object agg_elements = new LinkedList();
        ASPOperator.BinaryOperator right_op = null;
        ASPOperator.BinaryOperator left_op = null;
        Term<?> leftTerm = null;
        Term<?> rightTerm = null;
        int i = 0;
        if (node.jjtGetChild(0) instanceof ASTTerm) {
            leftTerm = this.visit((ASTTerm)node.jjtGetChild(i), null);
            left_op = this.evaluateBinop(this.visit((ASTBinop)node.jjtGetChild(i + 1), null));
            i += 2;
        }
        ASPOperator.AggregateFunction result_func = InstantiateVisitor.evaluateAggrFunc(this.visit((ASTAggrFunc)node.jjtGetChild(i), null));
        if (node.jjtGetChild(++i) instanceof ASTAggrElementList) {
            agg_elements = this.visit((ASTAggrElementList)node.jjtGetChild(i), null);
            ++i;
        }
        if (node.jjtGetNumChildren() > i && node.jjtGetChild(i + 1) instanceof ASTTerm) {
            right_op = this.evaluateBinop(this.visit((ASTBinop)node.jjtGetChild(i), null));
            rightTerm = this.visit((ASTTerm)node.jjtGetChild(i + 1), null);
        }
        return new AggregateAtom(result_func, (List<AggregateElement>)agg_elements, right_op, rightTerm, left_op, leftTerm);
    }

    public static ASPOperator.AggregateFunction evaluateAggrFunc(String func) {
        ASPOperator.AggregateFunction result_func = null;
        if (func.equals("#count")) {
            result_func = ASPOperator.AggregateFunction.COUNT;
        } else if (func.equals("#max")) {
            result_func = ASPOperator.AggregateFunction.MAX;
        } else if (func.equals("#min")) {
            result_func = ASPOperator.AggregateFunction.MIN;
        } else if (func.equals("#sum")) {
            result_func = ASPOperator.AggregateFunction.SUM;
        } else {
            try {
                throw new ParseException("Parser returned unknown operator");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return result_func;
    }

    @Override
    public List<AggregateElement> visit(ASTAggrElementList node, Object data) {
        LinkedList<AggregateElement> agg_elem_list = new LinkedList<AggregateElement>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (!(node.jjtGetChild(i) instanceof ASTAggrElement)) continue;
            AggregateElement a = this.visit((ASTAggrElement)node.jjtGetChild(i), null);
            agg_elem_list.add(a);
        }
        return agg_elem_list;
    }

    @Override
    public AggregateElement visit(ASTAggrElement node, Object data) {
        Object l = new ArrayList();
        Object l2 = new ArrayList<ASPBodyElement>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (node.jjtGetChild(i) instanceof ASTTermList) {
                l = this.visit((ASTTermList)node.jjtGetChild(i), null);
                continue;
            }
            if (!(node.jjtGetChild(i) instanceof ASTNAFLiteralList)) continue;
            l2 = this.visit((ASTNAFLiteralList)node.jjtGetChild(i), null);
        }
        return new AggregateElement((List<Term<?>>)l, (List<ASPBodyElement>)l2);
    }

    @Override
    public List<ASPRule> visit(ASTOpt node, Object data) {
        ArrayList<ASPRule> optelements = new ArrayList<ASPRule>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (!(node.jjtGetChild(i) instanceof ASTOptElementList)) continue;
            optelements.addAll((Collection<ASPRule>)this.visit((ASTOptElementList)node.jjtGetChild(i), null));
        }
        if (((ASTOptFunc)node.jjtGetChild((int)0)).maximize) {
            for (ASPRule w : optelements) {
                Term<?> weight = w.getWeight();
                w.setWeight((Term<?>)new ArithmeticTerm(ASPOperator.ArithmeticOperator.MINUS, weight));
            }
        }
        return optelements;
    }

    @Override
    public List<ASPRule> visit(ASTOptElementList node, Object data) {
        ArrayList<ASPRule> optelements = new ArrayList<ASPRule>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (!(node.jjtGetChild(i) instanceof ASTOptElement)) continue;
            ASPRule r = this.visit((ASTOptElement)node.jjtGetChild(i), null);
            optelements.add(r);
        }
        return optelements;
    }

    @Override
    public ASPRule visit(ASTOptElement node, Object data) {
        Object terms = this.visit((ASTWeight)node.jjtGetChild(0), null);
        Term weight = (Term)terms.remove(0);
        Term level = null;
        if (node.hasLevel) {
            level = (Term)terms.remove(0);
        }
        Object nafliterals = new ArrayList<ASPBodyElement>();
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            if (!(node.jjtGetChild(i) instanceof ASTNAFLiteralList)) continue;
            nafliterals = this.visit((ASTNAFLiteralList)node.jjtGetChild(i), null);
        }
        ASPRule wc = new ASPRule((List<ASPBodyElement>)nafliterals, (Term<?>)weight, (List<Term<?>>)terms);
        if (level != null) {
            wc.setLevel(level);
        }
        return wc;
    }

    @Override
    public List<Term<?>> visit(ASTWeight node, Object data) {
        ArrayList terms = new ArrayList();
        Term<?> t1 = this.visit((ASTTerm)node.jjtGetChild(0), null);
        terms.add(t1);
        if (node.jjtGetNumChildren() <= 1) {
            return terms;
        }
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            if (node.jjtGetChild(i) instanceof ASTTerm) {
                Term<?> t2 = this.visit((ASTTerm)node.jjtGetChild(i), null);
                terms.add(t2);
                continue;
            }
            if (!(node.jjtGetChild(i) instanceof ASTTermList)) continue;
            Object t3 = this.visit((ASTTermList)node.jjtGetChild(i), null);
            terms.addAll((Collection<Term<?>>)t3);
            break;
        }
        return terms;
    }

    @Override
    public List<ASPBodyElement> visit(ASTNAFLiteralList node, Object data) {
        LinkedList<ASPBodyElement> naflits = new LinkedList<ASPBodyElement>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (!(node.jjtGetChild(i) instanceof ASTNAFLiteral)) continue;
            ASPBodyElement n = this.visit((ASTNAFLiteral)node.jjtGetChild(i), null);
            naflits.add(n);
        }
        return naflits;
    }

    @Override
    public ASPBodyElement visit(ASTNAFLiteral node, Object data) {
        ASPBodyElement at = null;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (node.jjtGetChild(i) instanceof ASTBuiltInAtom) {
                at = this.visit((ASTBuiltInAtom)node.jjtGetChild(i), null);
                continue;
            }
            if (!(node.jjtGetChild(i) instanceof ASTLiteral)) continue;
            at = this.visit((ASTLiteral)node.jjtGetChild(i), null);
            if (!node.nafneg) continue;
            return new DefaultNegation(at);
        }
        return at;
    }

    @Override
    public ASPLiteral visit(ASTLiteral node, Object data) {
        String name = "";
        Object terms = new ArrayList();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (node.jjtGetChild(i) instanceof ASTID) {
                name = this.visit((ASTID)node.jjtGetChild(i), null);
            }
            if (!(node.jjtGetChild(i) instanceof ASTTermList)) continue;
            terms = this.visit((ASTTermList)node.jjtGetChild(i), null);
        }
        ASPAtom at = new ASPAtom(new Predicate(name, terms.size()), (List<Term<?>>)terms);
        if (node.neg) {
            return new StrictNegation(at);
        }
        return at;
    }

    @Override
    public ComparativeAtom visit(ASTBuiltInAtom node, Object data) {
        Term<?> t1;
        String op;
        Term<?> t2 = this.visit((ASTTerm)node.jjtGetChild(2), null);
        if (node.jjtGetChild(0) instanceof ASTBinop) {
            op = this.visit((ASTBinop)node.jjtGetChild(0), null);
            t1 = this.visit((ASTTerm)node.jjtGetChild(1), null);
        } else {
            op = this.visit((ASTBinop)node.jjtGetChild(1), null);
            t1 = this.visit((ASTTerm)node.jjtGetChild(0), null);
        }
        ASPOperator.BinaryOperator result_op = this.evaluateBinop(op);
        return new ComparativeAtom(result_op, t1, t2);
    }

    public ASPOperator.BinaryOperator evaluateBinop(String op) {
        ASPOperator.BinaryOperator result_op = ASPOperator.BinaryOperator.EQ;
        if (op.equals("=") || op.equals("==")) {
            result_op = ASPOperator.BinaryOperator.EQ;
        } else if (op.equals("<>") || op.equals("!=")) {
            result_op = ASPOperator.BinaryOperator.NEQ;
        } else if (op.equals("<")) {
            result_op = ASPOperator.BinaryOperator.LT;
        } else if (op.equals(">")) {
            result_op = ASPOperator.BinaryOperator.GT;
        } else if (op.equals("<=")) {
            result_op = ASPOperator.BinaryOperator.LEQ;
        } else if (op.equals(">=")) {
            result_op = ASPOperator.BinaryOperator.GEQ;
        } else {
            try {
                throw new ParseException("Parser returned unknown operator");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return result_op;
    }

    @Override
    public List<Term<?>> visit(ASTTermList node, Object data) {
        LinkedList term_list = new LinkedList();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (!(node.jjtGetChild(i) instanceof ASTTerm)) continue;
            Term<?> a = this.visit((ASTTerm)node.jjtGetChild(i), null);
            term_list.add(a);
        }
        return term_list;
    }

    public Term<?> visit(ASTTerm node, Object data) {
        Object t = null;
        if (node.jjtGetChild(0) instanceof ASTID) {
            if (node.jjtGetChild(1) instanceof ASTTermList) {
                Object terms = this.visit((ASTTermList)node.jjtGetChild(1), null);
                Functor f = new Functor(((ASTID)node.jjtGetChild((int)0)).name);
                t = new FunctionalTerm(f, (List)terms);
            } else {
                t = new Constant(((ASTID)node.jjtGetChild((int)0)).name);
            }
        } else if (node.jjtGetChild(0) instanceof ASTNumber) {
            t = new NumberTerm(((ASTNumber)node.jjtGetChild((int)0)).number);
        } else if (node.jjtGetChild(0) instanceof ASTVar) {
            t = new Variable(((ASTVar)node.jjtGetChild((int)0)).name);
        } else if (node.jjtGetChild(0) instanceof ASTString) {
            t = new Constant(((ASTString)node.jjtGetChild((int)0)).name);
        } else if (node.neg) {
            Term<?> t1 = this.visit((ASTTerm)node.jjtGetChild(0), null);
            t = new ArithmeticTerm(ASPOperator.ArithmeticOperator.MINUS, t1);
        } else {
            t = this.visit((ASTTerm)node.jjtGetChild(0), null);
        }
        if (node.jjtGetNumChildren() == 0) {
            return t;
        }
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            if (!(node.jjtGetChild(i) instanceof ASTAriTerm)) continue;
            Term<?> t2 = this.visit((ASTAriTerm)node.jjtGetChild(i), null);
            ASPOperator.ArithmeticOperator op = InstantiateVisitor.evaluateArithop(((ASTAriTerm)node.jjtGetChild((int)i)).op);
            if (op == null) continue;
            return new ArithmeticTerm(op, (Term<?>)t, t2);
        }
        return t;
    }

    public static ASPOperator.ArithmeticOperator evaluateArithop(String sop) {
        ASPOperator.ArithmeticOperator result_op = ASPOperator.ArithmeticOperator.PLUS;
        if (sop.equals("+")) {
            result_op = ASPOperator.ArithmeticOperator.PLUS;
        } else if (sop.equals("-")) {
            result_op = ASPOperator.ArithmeticOperator.MINUS;
        } else if (sop.equals("/")) {
            result_op = ASPOperator.ArithmeticOperator.DIV;
        } else if (sop.equals("*")) {
            result_op = ASPOperator.ArithmeticOperator.TIMES;
        } else {
            if (sop.equals("")) {
                return null;
            }
            try {
                throw new ParseException("Parser returned unknown operator");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return result_op;
    }

    public Term<?> visit(ASTAriTerm node, Object data) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (!(node.jjtGetChild(i) instanceof ASTTerm)) continue;
            return this.visit((ASTTerm)node.jjtGetChild(i), null);
        }
        return null;
    }

    @Override
    public String visit(ASTBinop node, Object data) {
        return node.operator;
    }

    @Override
    public String visit(ASTArithop node, Object data) {
        return node.operator;
    }

    @Override
    public String visit(ASTAggrFunc node, Object data) {
        return node.func;
    }

    @Override
    public String visit(ASTOptFunc node, Object data) {
        return node.func;
    }

    @Override
    public Integer visit(ASTNumber node, Object data) {
        return node.number;
    }

    @Override
    public String visit(ASTVar node, Object data) {
        return node.name;
    }

    @Override
    public String visit(ASTID node, Object data) {
        return node.name;
    }

    @Override
    public String visit(ASTString node, Object data) {
        return node.name;
    }

    @Override
    public String visit(ASTClingoMeta node, Object data) {
        return node.statement;
    }
}

