/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.lp.asp.reasoner;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.tweety.commons.InferenceMode;
import net.sf.tweety.commons.util.Shell;
import net.sf.tweety.lp.asp.parser.ASPCore2Parser;
import net.sf.tweety.lp.asp.parser.ParseException;
import net.sf.tweety.lp.asp.reasoner.ASPSolver;
import net.sf.tweety.lp.asp.reasoner.SolverException;
import net.sf.tweety.lp.asp.semantics.AnswerSet;
import net.sf.tweety.lp.asp.syntax.ASPLiteral;
import net.sf.tweety.lp.asp.syntax.Program;
import net.sf.tweety.lp.asp.writer.ClingoWriter;

public class ClingoSolver
extends ASPSolver {
    protected String pathToSolver = null;
    private Shell bash;
    private boolean usePredicateWhitelist = false;
    private String options = "";

    public ClingoSolver(String path2clingo, Shell bash) {
        this.pathToSolver = path2clingo;
        this.bash = bash;
    }

    public ClingoSolver(String path2clingo) {
        this.pathToSolver = path2clingo;
        this.bash = Shell.getNativeShell();
    }

    public List<AnswerSet> getModels(Program p) {
        List<AnswerSet> result = new ArrayList<AnswerSet>();
        try {
            File file = File.createTempFile("tmp", ".txt");
            ClingoWriter writer = new ClingoWriter(new PrintWriter(file), this.usePredicateWhitelist);
            writer.printProgram(p);
            writer.close();
            String cmd = this.pathToSolver + "/clingo -n " + this.maxNumOfModels + " " + this.options + " " + file.getAbsolutePath();
            result = this.parseResult(this.bash.run(cmd));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private List<AnswerSet> parseResult(String output) throws SolverException, ParseException {
        AnswerSet a;
        ArrayList<AnswerSet> result = new ArrayList<AnswerSet>();
        if (output.contains("UNSATISFIABLE")) {
            return result;
        }
        if (!output.contains("SATISFIABLE")) {
            int error_index = output.indexOf("error");
            if (error_index != -1) {
                throw new SolverException("Clingo error: " + output.substring(error_index), 1);
            }
            throw new SolverException("Clingo returned no output that can be interpreted: " + output, 1);
        }
        String[] as = output.split("Answer:\\s*[0-9]*\n");
        for (int i = 1; i < as.length - 1; ++i) {
            a = ASPCore2Parser.parseAnswerSet(as[i]);
            result.add(a);
        }
        String[] final_as = as[as.length - 1].split("\n");
        a = ASPCore2Parser.parseAnswerSet(final_as[0]);
        result.add(a);
        return result;
    }

    public List<AnswerSet> getModels(String s) {
        List<AnswerSet> result = new ArrayList<AnswerSet>();
        try {
            File file = File.createTempFile("tmp", ".txt");
            PrintWriter writer = new PrintWriter(file);
            writer.write(s);
            writer.close();
            String cmd = this.pathToSolver + "/clingo -n " + this.maxNumOfModels + " " + this.options + " " + file.getAbsolutePath();
            this.outputData = this.bash.run(cmd);
            result = this.parseResult(this.outputData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<AnswerSet> getModels(File file) {
        List<AnswerSet> result = new ArrayList<AnswerSet>();
        try {
            String cmd = this.pathToSolver + "/clingo -n " + this.maxNumOfModels + " " + this.options + " " + file.getAbsolutePath();
            this.outputData = this.bash.run(cmd);
            result = this.parseResult(this.outputData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Boolean query(Program beliefbase, ASPLiteral formula) {
        return this.query(beliefbase, formula, InferenceMode.SKEPTICAL);
    }

    public Boolean query(Program beliefbase, ASPLiteral formula, InferenceMode inferenceMode) {
        Collection answerSets = this.getModels(beliefbase);
        if (inferenceMode.equals((Object)InferenceMode.SKEPTICAL)) {
            for (AnswerSet e : answerSets) {
                if (e.contains(formula)) continue;
                return false;
            }
            return true;
        }
        for (AnswerSet e : answerSets) {
            if (!e.contains(formula)) continue;
            return true;
        }
        return false;
    }

    public AnswerSet getModel(Program p) {
        AnswerSet result = new AnswerSet();
        try {
            File file = File.createTempFile("tmp", ".txt");
            ClingoWriter writer = new ClingoWriter(new PrintWriter(file), this.usePredicateWhitelist);
            writer.printProgram(p);
            writer.close();
            String cmd = this.pathToSolver + "/clingo -n " + this.maxNumOfModels + " " + this.options + "  1 " + file.getAbsolutePath();
            this.outputData = this.bash.run(cmd);
            result = this.parseResult(this.outputData).get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void toggleOutputWhitelist(boolean b) {
        this.usePredicateWhitelist = b;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public void setPathToDLV(String path) {
        this.pathToSolver = path;
    }
}

