/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.lp.asp.reasoner;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.tweety.commons.InferenceMode;
import net.sf.tweety.commons.util.Shell;
import net.sf.tweety.lp.asp.parser.ASPCore2Parser;
import net.sf.tweety.lp.asp.reasoner.ASPSolver;
import net.sf.tweety.lp.asp.semantics.AnswerSet;
import net.sf.tweety.lp.asp.syntax.ASPLiteral;
import net.sf.tweety.lp.asp.syntax.Program;
import net.sf.tweety.lp.asp.writer.ClingoWriter;

public class DLVSolver
extends ASPSolver {
    private String pathToSolver;
    private Shell bash;
    private String options = "";

    public DLVSolver(String pathToDLV) {
        this.pathToSolver = pathToDLV;
        this.bash = Shell.getNativeShell();
    }

    public DLVSolver(String pathToDLV, Shell bash) {
        this.pathToSolver = pathToDLV;
        this.bash = bash;
    }

    public List<AnswerSet> getModels(Program p) {
        List<AnswerSet> result = new ArrayList<AnswerSet>();
        try {
            File file = File.createTempFile("tmp", ".txt");
            ClingoWriter writer = new ClingoWriter(new PrintWriter(file));
            writer.printProgram(p);
            writer.close();
            String cmd = this.pathToSolver + "/dlv -silent -n=" + this.maxNumOfModels + " -N=" + Integer.toString(this.integerMaximum) + " " + this.options + " " + file.getAbsolutePath();
            this.outputData = this.bash.run(cmd);
            result = this.parseResult(this.outputData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<AnswerSet> getModels(String p) {
        List<AnswerSet> result = new ArrayList<AnswerSet>();
        try {
            File file = File.createTempFile("tmp", ".txt");
            PrintWriter writer = new PrintWriter(file);
            writer.write(p);
            writer.close();
            String cmd = this.pathToSolver + "/dlv -silent -n=" + this.maxNumOfModels + " -N=" + Integer.toString(this.integerMaximum) + " " + this.options + " " + file.getAbsolutePath();
            this.outputData = this.bash.run(cmd);
            result = this.parseResult(this.outputData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<AnswerSet> getModels(File file) {
        List<AnswerSet> result = new ArrayList<AnswerSet>();
        try {
            String cmd = this.pathToSolver + "/dlv -silent -n=" + this.maxNumOfModels + " -N=" + Integer.toString(this.integerMaximum) + " " + this.options + " " + file.getAbsolutePath();
            this.outputData = this.bash.run(cmd);
            result = this.parseResult(this.outputData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public AnswerSet getModel(Program p) {
        return (AnswerSet)((Object)this.getModels(p).iterator().next());
    }

    protected List<AnswerSet> parseResult(String s) {
        ArrayList<AnswerSet> result = new ArrayList<AnswerSet>();
        String[] temp = s.split("}");
        try {
            for (int i = 0; i < temp.length - 1; ++i) {
                String toParse = temp[i].trim().substring(1).replaceAll(",", "");
                AnswerSet as = ASPCore2Parser.parseAnswerSet(toParse);
                result.add(as);
            }
        }
        catch (Exception e) {
            System.err.println("DLV error: Failed to parse answer sets from DLV output");
            e.printStackTrace();
        }
        return result;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public void setPathToDLV(String pathToDLV) {
        this.pathToSolver = pathToDLV;
    }

    @Override
    public Boolean query(Program beliefbase, ASPLiteral formula) {
        return this.query(beliefbase, formula, InferenceMode.SKEPTICAL);
    }

    public Boolean query(Program beliefbase, ASPLiteral formula, InferenceMode inferenceMode) {
        Collection answerSets = this.getModels(beliefbase);
        if (inferenceMode.equals((Object)InferenceMode.SKEPTICAL)) {
            for (AnswerSet e : answerSets) {
                if (e.contains(formula)) continue;
                return false;
            }
            return true;
        }
        for (AnswerSet e : answerSets) {
            if (!e.contains(formula)) continue;
            return true;
        }
        return false;
    }
}

