/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.lp.asp.syntax;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.tweety.logics.commons.error.LanguageException;
import net.sf.tweety.logics.commons.syntax.Predicate;
import net.sf.tweety.logics.commons.syntax.interfaces.Atom;
import net.sf.tweety.logics.commons.syntax.interfaces.Term;
import net.sf.tweety.logics.fol.syntax.FolAtom;
import net.sf.tweety.logics.fol.syntax.FolSignature;
import net.sf.tweety.lp.asp.syntax.ASPLiteral;
import net.sf.tweety.lp.asp.syntax.StrictNegation;

public class ASPAtom
extends ASPLiteral {
    protected Predicate predicate;
    protected List<Term<?>> arguments = new LinkedList();

    public ASPAtom() {
        this.predicate = null;
        this.arguments = new ArrayList();
    }

    public ASPAtom(Predicate p, List<Term<?>> terms) {
        if (p.isTyped()) {
            throw new IllegalArgumentException("Error: ASP predicates are typeless, the given predicate " + p + " is not.");
        }
        this.predicate = p;
        this.arguments = terms;
    }

    public ASPAtom(String name) {
        this(new Predicate(name));
    }

    public ASPAtom(FolAtom other) {
        if (other.getPredicate().isTyped()) {
            throw new IllegalArgumentException("Error: ASP predicates are typeless, the given atom's predicate " + other.getPredicate() + " is not.");
        }
        this.predicate = new Predicate(other.getPredicate().getName(), other.getArguments().size());
        for (Term t : other.getArguments()) {
            this.arguments.add(t.clone());
        }
    }

    public ASPAtom(ASPAtom other) {
        this.predicate = new Predicate(other.getName(), other.getPredicate().getArity());
        for (Term<?> t : other.getArguments()) {
            this.arguments.add(t.clone());
        }
    }

    public ASPAtom(String symbol, Term<?> ... terms) {
        this.predicate = new Predicate(symbol, terms.length);
        for (int i = 0; i < terms.length; ++i) {
            this.arguments.add(terms[i]);
        }
    }

    public ASPAtom(Predicate p) {
        this();
        if (p.isTyped()) {
            throw new IllegalArgumentException("Error: ASP predicates are typeless, the given predicate " + p + " is not.");
        }
        this.predicate = p;
    }

    public String getName() {
        return this.predicate.getName();
    }

    public String toString() {
        Object res = this.predicate.getName();
        if (this.predicate.getArity() > 0) {
            res = (String)res + "(";
            for (int i = 0; i < this.arguments.size() - 1; ++i) {
                res = (String)res + this.arguments.get(i).toString() + ",";
            }
            res = (String)res + this.arguments.get(this.arguments.size() - 1).toString() + ")";
        }
        return res;
    }

    @Override
    public SortedSet<ASPLiteral> getLiterals() {
        TreeSet<ASPLiteral> literals = new TreeSet<ASPLiteral>();
        literals.add(this);
        return literals;
    }

    @Override
    public Set<Predicate> getPredicates() {
        HashSet<Predicate> predicates = new HashSet<Predicate>();
        predicates.add(this.predicate);
        return predicates;
    }

    @Override
    public Set<ASPAtom> getAtoms() {
        HashSet<ASPAtom> atoms = new HashSet<ASPAtom>();
        atoms.add(this);
        return atoms;
    }

    @Override
    public FolSignature getSignature() {
        FolSignature sig = new FolSignature();
        sig.add((Object)this.predicate);
        sig.addAll(this.arguments);
        return sig;
    }

    @Override
    public ASPAtom clone() {
        return new ASPAtom(this);
    }

    public Set<Term<?>> getTerms() {
        HashSet terms = new HashSet();
        terms.addAll(this.arguments);
        return terms;
    }

    public <C extends Term<?>> Set<C> getTerms(Class<C> cls) {
        HashSet reval = new HashSet();
        for (Term<?> arg : this.arguments) {
            if (arg.getClass().equals(cls)) {
                Term<?> castArg = arg;
                reval.add(castArg);
            }
            reval.addAll(arg.getTerms(cls));
        }
        return reval;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public Atom.RETURN_SET_PREDICATE setPredicate(Predicate newer) {
        Predicate old = this.predicate;
        this.predicate = newer;
        return Atom.AtomImpl.implSetPredicate((Predicate)old, (Predicate)this.predicate, this.arguments);
    }

    public void addArgument(Term<?> arg) throws LanguageException {
        this.arguments.add(arg);
    }

    public List<? extends Term<?>> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public boolean isComplete() {
        return this.getTerms().size() == this.predicate.getArity();
    }

    @Override
    public int compareTo(ASPLiteral o) {
        if (o instanceof StrictNegation) {
            return -1;
        }
        return this.toString().compareTo(o.toString());
    }

    @Override
    public ASPAtom cloneWithAddedTerm(Term<?> term) {
        Predicate new_predicate = new Predicate(this.predicate.getName(), this.predicate.getArity() + 1);
        ArrayList args = new ArrayList(this.arguments);
        args.add(term);
        ASPAtom reval = new ASPAtom(new_predicate, args);
        return reval;
    }

    @Override
    public ASPAtom getAtom() {
        return this;
    }

    @Override
    public ASPLiteral complement() {
        return new StrictNegation(this);
    }

    @Override
    public ASPAtom substitute(Term<?> v, Term<?> t) throws IllegalArgumentException {
        ASPAtom reval = new ASPAtom(this);
        reval.arguments.clear();
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (this.arguments.get(i).equals(v)) {
                reval.arguments.add(t);
                continue;
            }
            reval.arguments.add(this.arguments.get(i));
        }
        return reval;
    }

    public Term<?> getTerm(int i) {
        return this.arguments.get(i);
    }

    public boolean equals(Object o) {
        if (o instanceof ASPAtom) {
            ASPAtom oa = (ASPAtom)o;
            if (oa.predicate != null ? !oa.predicate.equals((Object)this.predicate) : this.predicate != null) {
                return false;
            }
            return oa.arguments.equals(this.arguments);
        }
        return false;
    }

    public int hashCode() {
        return (this.predicate == null ? 0 : this.predicate.hashCode()) + this.arguments.hashCode();
    }
}

