/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.lp.asp.syntax;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.tweety.logics.commons.syntax.AssociativeFormulaSupport;
import net.sf.tweety.logics.commons.syntax.Constant;
import net.sf.tweety.logics.commons.syntax.Predicate;
import net.sf.tweety.logics.commons.syntax.Variable;
import net.sf.tweety.logics.commons.syntax.interfaces.AssociativeFormula;
import net.sf.tweety.logics.commons.syntax.interfaces.Atom;
import net.sf.tweety.logics.commons.syntax.interfaces.Disjunctable;
import net.sf.tweety.logics.commons.syntax.interfaces.SimpleLogicalFormula;
import net.sf.tweety.logics.commons.syntax.interfaces.Term;
import net.sf.tweety.logics.fol.syntax.FolSignature;
import net.sf.tweety.lp.asp.syntax.ASPAtom;
import net.sf.tweety.lp.asp.syntax.ASPElement;
import net.sf.tweety.lp.asp.syntax.ASPLiteral;

public class ASPHead
extends ASPElement
implements AssociativeFormula<ASPLiteral>,
Disjunctable,
AssociativeFormulaSupport.AssociativeSupportBridge {
    private AssociativeFormulaSupport<ASPLiteral> assocSupport = new AssociativeFormulaSupport((AssociativeFormulaSupport.AssociativeSupportBridge)this);

    public ASPHead() {
    }

    public ASPHead(List<ASPLiteral> head_elements) {
        this.addAll(head_elements);
    }

    public ASPHead(ASPLiteral head) {
        this.add(head);
    }

    public ASPHead(ASPHead other) {
        this(other.getFormulas());
    }

    @Override
    public boolean isGround() {
        return this.getTerms(Variable.class).isEmpty();
    }

    @Override
    public boolean isWellFormed() {
        return this.assocSupport.isWellFormed();
    }

    @Override
    public Class<? extends Predicate> getPredicateCls() {
        return this.assocSupport.getPredicateCls();
    }

    public boolean isLiteral() {
        return false;
    }

    public Set<Term<?>> getTerms() {
        HashSet terms = new HashSet();
        for (ASPLiteral l : this.getFormulas()) {
            terms.addAll(l.getTerms());
        }
        return terms;
    }

    public <C extends Term<?>> Set<C> getTerms(Class<C> cls) {
        HashSet terms = new HashSet();
        for (ASPLiteral l : this.getFormulas()) {
            terms.addAll(l.getTerms(cls));
        }
        return terms;
    }

    @Override
    public <C extends Term<?>> boolean containsTermsOfType(Class<C> cls) {
        return this.assocSupport.containsTermsOfType(cls);
    }

    @Override
    public Set<Predicate> getPredicates() {
        HashSet<Predicate> reval = new HashSet<Predicate>();
        for (Predicate pred : this.assocSupport.getPredicates()) {
            if (!(pred instanceof Predicate)) continue;
            reval.add(pred);
        }
        return reval;
    }

    @Override
    public Set<ASPAtom> getAtoms() {
        HashSet<ASPAtom> reval = new HashSet<ASPAtom>();
        for (Atom at : this.assocSupport.getAtoms()) {
            if (!(at instanceof ASPAtom)) continue;
            reval.add((ASPAtom)at);
        }
        return reval;
    }

    @Override
    public ASPHead substitute(Term<?> t, Term<?> v) {
        return (ASPHead)this.assocSupport.substitute(v, t);
    }

    @Override
    public FolSignature getSignature() {
        return (FolSignature)this.assocSupport.getSignature();
    }

    @Override
    public ASPHead clone() {
        return new ASPHead(this);
    }

    public boolean add(ASPLiteral e) {
        return this.assocSupport.add((SimpleLogicalFormula)e);
    }

    public void add(int index, ASPLiteral element) {
        this.assocSupport.add(index, (SimpleLogicalFormula)element);
    }

    public boolean addAll(Collection<? extends ASPLiteral> c) {
        return this.assocSupport.addAll(c);
    }

    public boolean addAll(int index, Collection<? extends ASPLiteral> c) {
        return this.assocSupport.addAll(index, c);
    }

    public boolean add(ASPLiteral ... formulas) {
        return this.assocSupport.add((SimpleLogicalFormula[])formulas);
    }

    public void clear() {
        this.assocSupport.clear();
    }

    public boolean contains(Object o) {
        return this.assocSupport.contains(o);
    }

    public boolean containsAll(Collection<?> c) {
        return this.assocSupport.containsAll(c);
    }

    public ASPLiteral get(int index) {
        return (ASPLiteral)this.assocSupport.get(index);
    }

    public int indexOf(Object o) {
        return this.assocSupport.indexOf(o);
    }

    public boolean isEmpty() {
        return this.assocSupport.isEmpty();
    }

    public Iterator<ASPLiteral> iterator() {
        return this.assocSupport.iterator();
    }

    public int lastIndexOf(Object o) {
        return this.assocSupport.lastIndexOf(o);
    }

    public ListIterator<ASPLiteral> listIterator() {
        return this.assocSupport.listIterator();
    }

    public ListIterator<ASPLiteral> listIterator(int index) {
        return this.assocSupport.listIterator(index);
    }

    public boolean remove(Object o) {
        return this.assocSupport.remove(o);
    }

    public ASPLiteral remove(int index) {
        return (ASPLiteral)this.assocSupport.remove(index);
    }

    public boolean removeAll(Collection<?> c) {
        return this.assocSupport.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return this.assocSupport.retainAll(c);
    }

    public ASPLiteral set(int index, ASPLiteral element) {
        return (ASPLiteral)this.assocSupport.set(index, (SimpleLogicalFormula)element);
    }

    public int size() {
        return this.assocSupport.size();
    }

    public List<ASPLiteral> subList(int fromIndex, int toIndex) {
        return this.assocSupport.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.assocSupport.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.assocSupport.toArray((Object[])a);
    }

    public List<ASPLiteral> getFormulas() {
        return this.assocSupport.getFormulas();
    }

    public <C extends SimpleLogicalFormula> Set<C> getFormulas(Class<C> cls) {
        return this.assocSupport.getFormulas(cls);
    }

    public ASPHead createEmptyFormula() {
        return new ASPHead();
    }

    public FolSignature createEmptySignature() {
        return new FolSignature();
    }

    public String getOperatorSymbol() {
        return ";";
    }

    public String getEmptySymbol() {
        return "";
    }

    public SimpleLogicalFormula combineWithOr(Disjunctable f) {
        if (!(f instanceof ASPLiteral)) {
            throw new IllegalArgumentException();
        }
        ASPLiteral arg = (ASPLiteral)f;
        ASPHead reval = new ASPHead(this);
        reval.add(arg);
        return reval;
    }

    public String toString() {
        return this.assocSupport.toString();
    }

    @Override
    public ASPHead substitute(Map<? extends Term<?>, ? extends Term<?>> map) throws IllegalArgumentException {
        ASPElement f = this;
        for (Term<?> v : map.keySet()) {
            f = f.substitute((Term)v, (Term)map.get(v));
        }
        return f;
    }

    @Override
    public ASPHead exchange(Term<?> v, Term<?> t) throws IllegalArgumentException {
        if (!v.getSort().equals((Object)t.getSort())) {
            throw new IllegalArgumentException("Terms '" + v + "' and '" + t + "' are of different sorts.");
        }
        Constant temp = new Constant("$TEMP$", v.getSort());
        ASPElement rf = this.substitute((Term)v, (Term)temp);
        rf = ((ASPHead)rf).substitute((Term)t, (Term)v);
        rf = ((ASPHead)rf).substitute((Term)temp, (Term)t);
        v.getSort().remove((Term)temp);
        return rf;
    }

    public SortedSet<ASPLiteral> getLiterals() {
        TreeSet<ASPLiteral> literals = new TreeSet<ASPLiteral>();
        Iterator<ASPLiteral> iterator = this.iterator();
        while (iterator.hasNext()) {
            ASPLiteral element = iterator.next();
            literals.addAll(element.getLiterals());
        }
        return literals;
    }

    public boolean equals(Object other) {
        if (other instanceof AssociativeFormula) {
            AssociativeFormula cast = (AssociativeFormula)other;
            return this.assocSupport.equals((Object)cast.getFormulas()) && this.getClass().equals(other.getClass());
        }
        return false;
    }

    public int hashCode() {
        return this.assocSupport.hashCode() + this.getClass().hashCode();
    }
}

