/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.lp.asp.syntax;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.sf.tweety.commons.util.rules.Rule;
import net.sf.tweety.logics.commons.syntax.Predicate;
import net.sf.tweety.logics.commons.syntax.interfaces.Term;
import net.sf.tweety.logics.fol.syntax.FolSignature;
import net.sf.tweety.lp.asp.syntax.ASPAtom;
import net.sf.tweety.lp.asp.syntax.ASPBodyElement;
import net.sf.tweety.lp.asp.syntax.ASPElement;
import net.sf.tweety.lp.asp.syntax.ASPHead;
import net.sf.tweety.lp.asp.syntax.ASPLiteral;

public class ASPRule
extends ASPElement
implements Rule<ASPHead, ASPBodyElement>,
Comparable<ASPRule> {
    private ASPHead head;
    private List<ASPBodyElement> body;
    private Term<?> weight;
    private Term<?> level;
    private List<Term<?>> constraint_terms;

    public ASPRule() {
        this.head = new ASPHead();
        this.body = new LinkedList<ASPBodyElement>();
        this.weight = null;
        this.level = null;
        this.constraint_terms = new LinkedList();
    }

    public ASPRule(ASPHead head) {
        this.head = head;
        this.body = new LinkedList<ASPBodyElement>();
        this.weight = null;
        this.level = null;
        this.constraint_terms = new LinkedList();
    }

    public ASPRule(ASPLiteral literal) {
        this();
        this.head = new ASPHead(literal);
    }

    public ASPRule(ASPHead head, List<ASPBodyElement> body) {
        this.head = head;
        this.body = body;
        this.weight = null;
        this.level = null;
        this.constraint_terms = new LinkedList();
    }

    public ASPRule(ASPLiteral head, ASPBodyElement b) {
        this(head);
        this.body.add(b);
        this.weight = null;
        this.level = null;
        this.constraint_terms = new LinkedList();
    }

    public ASPRule(ASPLiteral head, List<ASPBodyElement> body) {
        this.head = new ASPHead(head);
        this.body = body;
        this.weight = null;
        this.level = null;
        this.constraint_terms = new LinkedList();
    }

    public ASPRule(List<ASPBodyElement> body) {
        this();
        this.body = body;
    }

    public ASPRule(List<ASPBodyElement> nafliterals, Term<?> weight, List<Term<?>> terms) {
        this();
        this.body = nafliterals;
        this.weight = weight;
        this.constraint_terms = terms;
    }

    public ASPRule(List<ASPBodyElement> body, Term<?> weight, Term<?> level, List<Term<?>> terms) {
        this.head = new ASPHead();
        this.body = body;
        this.weight = weight;
        this.level = level;
        this.constraint_terms = terms;
    }

    public ASPRule(ASPRule other) {
        this(other.body, other.weight, other.level, other.constraint_terms);
        this.head = other.head;
    }

    public Boolean isSafe() {
        throw new UnsupportedOperationException("WIP");
    }

    public boolean isFact() {
        return this.body.isEmpty() && !this.head.isEmpty();
    }

    public boolean isConstraint() {
        return this.head.isEmpty() && !this.body.isEmpty();
    }

    public void addPremises(Collection<? extends ASPBodyElement> premises) {
        this.body.addAll(premises);
    }

    @Override
    public FolSignature getSignature() {
        FolSignature sig = new FolSignature();
        sig.add((Object)this.head.getSignature());
        for (ASPBodyElement a : this.body) {
            sig.add((Object)a.getSignature());
        }
        return sig;
    }

    public void setConclusion(ASPHead conclusion) {
        this.head = conclusion;
    }

    public void setConclusion(ASPLiteral head) {
        this.head = new ASPHead(head);
    }

    public void addPremise(ASPBodyElement premise) {
        this.body.add(premise);
    }

    public List<ASPBodyElement> getPremise() {
        return this.body;
    }

    public ASPHead getConclusion() {
        return this.head;
    }

    public String toString() {
        int i;
        Object ret = "";
        if (!this.head.isEmpty()) {
            for (i = 0; i < this.head.size() - 1; ++i) {
                ret = (String)ret + this.head.get(i).toString() + ",";
            }
            ret = (String)ret + this.head.get(this.head.size() - 1).toString();
        }
        if (!this.body.isEmpty()) {
            ret = (String)ret + ":- " + this.body.get(0);
            for (i = 1; i < this.body.size(); ++i) {
                ret = (String)ret + ", " + this.body.get(i);
            }
        }
        ret = (String)ret + ".";
        if (this.weight != null) {
            ret = (String)ret + " [" + this.weight.toString();
            if (this.level != null) {
                ret = (String)ret + "@" + this.level.toString();
            }
            if (!this.constraint_terms.isEmpty()) {
                ret = (String)ret + ",";
                for (i = 1; i < this.constraint_terms.size() - 1; ++i) {
                    ret = (String)ret + this.constraint_terms.get(i) + ",";
                }
                ret = (String)ret + this.constraint_terms.get(this.constraint_terms.size() - 1).toString();
            }
            ret = (String)ret + "]";
        }
        return ret;
    }

    public Term<?> getWeight() {
        return this.weight;
    }

    public void setWeight(Term<?> weight) {
        this.weight = weight;
    }

    public Term<?> getLevel() {
        return this.level;
    }

    public void setLevel(Term<?> level) {
        this.level = level;
    }

    public ASPHead getHead() {
        return this.head;
    }

    public void setHead(ASPHead head) {
        this.head = head;
    }

    public void addToHead(ASPLiteral h) {
        this.head.add(h);
    }

    public List<ASPBodyElement> getBody() {
        return this.body;
    }

    public void setBody(List<ASPBodyElement> body) {
        this.body = body;
    }

    public List<Term<?>> getConstraintTerms() {
        return this.constraint_terms;
    }

    @Override
    public boolean isGround() {
        if (!this.head.isGround()) {
            return false;
        }
        for (ASPBodyElement a : this.body) {
            if (a.isGround()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(ASPRule arg0) {
        int comp = 0;
        if (this.getPremise().size() == 0 && arg0.getPremise().size() != 0) {
            return -1;
        }
        if (this.getPremise().size() != 0 && arg0.getPremise().size() == 0) {
            return 1;
        }
        comp = this.getConclusion().toString().compareTo(arg0.getConclusion().toString());
        if (comp != 0) {
            return comp;
        }
        for (int i = 0; i < this.body.size() && i < arg0.body.size(); ++i) {
            comp = this.body.get(i).toString().compareTo(arg0.body.get(i).toString());
            if (comp == 0) continue;
            return comp;
        }
        return comp;
    }

    public Collection<? extends ASPLiteral> getLiterals() {
        TreeSet<ASPLiteral> literals = new TreeSet<ASPLiteral>();
        literals.addAll((Collection<ASPLiteral>)((Object)this.head));
        for (ASPBodyElement pe : this.body) {
            literals.addAll(pe.getLiterals());
        }
        return literals;
    }

    @Override
    public ASPRule substitute(Term<?> v, Term<?> t) {
        ASPRule reval = new ASPRule();
        reval.head = this.head.substitute((Term)v, (Term)t);
        for (ASPBodyElement bodyElement : this.body) {
            reval.body.add((ASPBodyElement)bodyElement.substitute((Term)v, (Term)t));
        }
        return reval;
    }

    @Override
    public ASPRule exchange(Term<?> v, Term<?> t) {
        ASPRule reval = new ASPRule();
        reval.head = this.head.exchange((Term)v, (Term)t);
        for (ASPBodyElement bodyElement : this.body) {
            reval.body.add((ASPBodyElement)bodyElement.exchange((Term)v, (Term)t));
        }
        return reval;
    }

    public boolean isLiteral() {
        return false;
    }

    public Set<Term<?>> getTerms() {
        HashSet terms = new HashSet();
        terms.addAll(this.head.getTerms());
        for (ASPBodyElement be : this.body) {
            terms.addAll(be.getTerms());
        }
        if (this.level != null) {
            terms.addAll(this.level.getTerms());
        }
        if (this.weight != null) {
            terms.addAll(this.weight.getTerms());
        }
        terms.addAll(this.constraint_terms);
        return terms;
    }

    public <C extends Term<?>> Set<C> getTerms(Class<C> cls) {
        HashSet<C> terms = new HashSet<C>();
        terms.addAll(this.head.getTerms(cls));
        for (ASPBodyElement aSPBodyElement : this.body) {
            terms.addAll(aSPBodyElement.getTerms(cls));
        }
        if (this.level != null) {
            terms.addAll(this.level.getTerms(cls));
        }
        if (this.weight != null) {
            terms.addAll(this.weight.getTerms(cls));
        }
        for (Term term : this.constraint_terms) {
            terms.addAll(term.getTerms(cls));
        }
        return terms;
    }

    @Override
    public Set<Predicate> getPredicates() {
        HashSet<Predicate> predicates = new HashSet<Predicate>();
        predicates.addAll(this.head.getPredicates());
        for (ASPBodyElement be : this.body) {
            predicates.addAll(be.getPredicates());
        }
        return predicates;
    }

    @Override
    public Set<ASPAtom> getAtoms() {
        HashSet<ASPAtom> atoms = new HashSet<ASPAtom>();
        atoms.addAll(this.head.getAtoms());
        for (ASPBodyElement be : this.body) {
            atoms.addAll(be.getAtoms());
        }
        return atoms;
    }

    @Override
    public ASPRule clone() {
        return new ASPRule(this);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Rule)) {
            return false;
        }
        ASPRule or = (ASPRule)other;
        boolean reval = this.head.equals(or.head) && this.body.equals(or.body);
        return reval;
    }

    public int hashCode() {
        return this.head.hashCode() + this.body.hashCode();
    }

    public boolean isEmpty() {
        return this.head.isEmpty() && this.body.isEmpty();
    }
}

