/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.lp.asp.syntax;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.tweety.logics.commons.syntax.Constant;
import net.sf.tweety.logics.commons.syntax.Predicate;
import net.sf.tweety.logics.commons.syntax.interfaces.Term;
import net.sf.tweety.logics.fol.syntax.FolSignature;
import net.sf.tweety.lp.asp.syntax.ASPAtom;
import net.sf.tweety.lp.asp.syntax.ASPBodyElement;
import net.sf.tweety.lp.asp.syntax.ASPLiteral;
import net.sf.tweety.lp.asp.syntax.ASPOperator;
import net.sf.tweety.lp.asp.syntax.AggregateElement;

public class AggregateAtom
extends ASPBodyElement {
    private ASPOperator.AggregateFunction function;
    private List<AggregateElement> aggregateElements;
    private ASPOperator.BinaryOperator rightOp;
    private Term<?> rightGuard;
    private ASPOperator.BinaryOperator leftOp;
    private Term<?> leftGuard;

    public AggregateAtom() {
        this.rightOp = null;
        this.function = null;
        this.aggregateElements = new LinkedList<AggregateElement>();
        this.rightGuard = null;
        this.leftOp = null;
        this.leftGuard = null;
    }

    public AggregateAtom(ASPOperator.AggregateFunction func, List<AggregateElement> elements) {
        this();
        this.aggregateElements = elements;
        this.function = func;
    }

    public AggregateAtom(ASPOperator.AggregateFunction func, List<AggregateElement> elements, ASPOperator.BinaryOperator relation, Term<?> t) {
        this.aggregateElements = elements;
        this.function = func;
        this.rightOp = relation;
        this.rightGuard = t;
    }

    public AggregateAtom(ASPOperator.AggregateFunction func, List<AggregateElement> elements, ASPOperator.BinaryOperator relation, Term<?> t, ASPOperator.BinaryOperator relation2, Term<?> t2) {
        this.aggregateElements = elements;
        this.function = func;
        this.rightOp = relation;
        this.rightGuard = t;
        this.leftOp = relation2;
        this.leftGuard = t2;
    }

    public AggregateAtom(AggregateAtom other) {
        this(other.getFunction(), other.getAggregateElements(), other.getRightOperator(), other.getRightGuard(), other.getLeftOperator(), other.getLeftGuard());
    }

    public String toString() {
        Object res = "";
        if (this.hasLeftRelation()) {
            res = (String)res + this.leftGuard.toString() + this.leftOp.toString();
        }
        res = (String)res + this.function.toString() + "{";
        for (int i = 0; i < this.aggregateElements.size() - 1; ++i) {
            res = (String)res + this.aggregateElements.get(i) + " ; ";
        }
        res = (String)res + this.aggregateElements.get(this.aggregateElements.size() - 1) + "}";
        if (this.hasRightRelation()) {
            res = (String)res + this.rightOp.toString() + this.rightGuard.toString();
        }
        return res;
    }

    @Override
    public SortedSet<ASPLiteral> getLiterals() {
        TreeSet<ASPLiteral> literals = new TreeSet<ASPLiteral>();
        for (AggregateElement a : this.aggregateElements) {
            literals.addAll(a.getLiterals());
        }
        return literals;
    }

    @Override
    public Set<Predicate> getPredicates() {
        HashSet<Predicate> predicates = new HashSet<Predicate>();
        for (AggregateElement e : this.aggregateElements) {
            predicates.addAll(e.getPredicates());
        }
        return predicates;
    }

    @Override
    public Set<ASPAtom> getAtoms() {
        HashSet<ASPAtom> atoms = new HashSet<ASPAtom>();
        for (AggregateElement e : this.aggregateElements) {
            atoms.addAll(e.getAtoms());
        }
        return atoms;
    }

    @Override
    public AggregateAtom substitute(Term<?> t, Term<?> v) {
        AggregateAtom reval = new AggregateAtom(this);
        if (t.equals(this.leftGuard)) {
            reval.leftGuard = v;
        }
        if (t.equals(this.rightGuard)) {
            reval.rightGuard = v;
        }
        return reval;
    }

    @Override
    public FolSignature getSignature() {
        FolSignature sig = new FolSignature();
        for (AggregateElement e : this.aggregateElements) {
            sig.add((Object)e.getSignature());
        }
        if (this.rightGuard != null) {
            sig.add((Object)this.rightGuard.getTerms(Constant.class));
        }
        if (this.leftGuard != null) {
            sig.add((Object)this.leftGuard.getTerms(Constant.class));
        }
        return sig;
    }

    @Override
    public AggregateAtom clone() {
        return new AggregateAtom(this);
    }

    public boolean isLiteral() {
        return false;
    }

    public Set<Term<?>> getTerms() {
        HashSet terms = new HashSet();
        for (AggregateElement e : this.aggregateElements) {
            terms.addAll(e.getTerms());
        }
        if (this.hasRightRelation()) {
            terms.addAll(this.rightGuard.getTerms());
        }
        if (this.hasLeftRelation()) {
            terms.addAll(this.leftGuard.getTerms());
        }
        return terms;
    }

    public <C extends Term<?>> Set<C> getTerms(Class<C> cls) {
        HashSet<C> terms = new HashSet<C>();
        for (AggregateElement e : this.aggregateElements) {
            terms.addAll(e.getTerms(cls));
        }
        if (this.hasRightRelation()) {
            terms.addAll(this.rightGuard.getTerms(cls));
        }
        if (this.hasLeftRelation()) {
            terms.addAll(this.leftGuard.getTerms(cls));
        }
        return terms;
    }

    public List<AggregateElement> getAggregateElements() {
        return this.aggregateElements;
    }

    public boolean hasLeftRelation() {
        return this.leftGuard != null && this.leftOp != null;
    }

    public boolean hasRightRelation() {
        return this.rightGuard != null && this.rightOp != null;
    }

    public ASPOperator.AggregateFunction getFunction() {
        return this.function;
    }

    public void setFunction(ASPOperator.AggregateFunction function) {
        this.function = function;
    }

    public ASPOperator.BinaryOperator getRightOperator() {
        return this.rightOp;
    }

    public void setRightOperator(ASPOperator.BinaryOperator op) {
        this.rightOp = op;
    }

    public Term<?> getRightGuard() {
        return this.rightGuard;
    }

    public void setRightGuard(Term<?> relationTerm) {
        this.rightGuard = relationTerm;
    }

    public ASPOperator.BinaryOperator getLeftOperator() {
        return this.leftOp;
    }

    public void setLeftOperator(ASPOperator.BinaryOperator op) {
        this.leftOp = op;
    }

    public Term<?> getLeftGuard() {
        return this.leftGuard;
    }

    public void setLeftGuard(Term<?> relationTerm) {
        this.leftGuard = relationTerm;
    }
}

