/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.lp.asp.syntax;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.tweety.logics.commons.syntax.Constant;
import net.sf.tweety.logics.commons.syntax.Predicate;
import net.sf.tweety.logics.commons.syntax.interfaces.Term;
import net.sf.tweety.logics.fol.syntax.FolSignature;
import net.sf.tweety.lp.asp.syntax.ASPAtom;
import net.sf.tweety.lp.asp.syntax.ASPBodyElement;
import net.sf.tweety.lp.asp.syntax.ASPElement;
import net.sf.tweety.lp.asp.syntax.ASPLiteral;

public class AggregateElement
extends ASPElement {
    private List<Term<?>> left;
    private List<ASPBodyElement> right;

    public AggregateElement(List<Term<?>> l, List<ASPBodyElement> r) {
        this.left = l;
        this.right = r;
    }

    public AggregateElement(AggregateElement other) {
        this.left = other.left;
        this.right = other.right;
    }

    public String toString() {
        int i;
        Object r = "";
        for (i = 0; i < this.left.size() - 1; ++i) {
            r = (String)r + this.left.get(i).toString() + ",";
        }
        r = (String)r + this.left.get(this.left.size() - 1);
        if (!this.right.isEmpty()) {
            r = (String)r + " : ";
            for (i = 0; i < this.right.size() - 1; ++i) {
                r = (String)r + this.right.get(i).toString() + ",";
            }
            r = (String)r + this.right.get(this.right.size() - 1);
        }
        return r;
    }

    public boolean isLiteral() {
        return false;
    }

    public Set<Term<?>> getTerms() {
        HashSet terms = new HashSet();
        for (Term<?> term : this.left) {
            terms.addAll(term.getTerms());
        }
        for (ASPBodyElement aSPBodyElement : this.right) {
            terms.addAll(aSPBodyElement.getTerms());
        }
        return terms;
    }

    public <C extends Term<?>> Set<C> getTerms(Class<C> cls) {
        HashSet terms = new HashSet();
        for (Term<?> term : this.left) {
            terms.addAll(term.getTerms(cls));
        }
        for (ASPBodyElement aSPBodyElement : this.right) {
            terms.addAll(aSPBodyElement.getTerms(cls));
        }
        return terms;
    }

    @Override
    public Set<Predicate> getPredicates() {
        HashSet<Predicate> predicates = new HashSet<Predicate>();
        for (ASPBodyElement t : this.right) {
            predicates.addAll(t.getPredicates());
        }
        return predicates;
    }

    @Override
    public Set<ASPAtom> getAtoms() {
        HashSet<ASPAtom> atoms = new HashSet<ASPAtom>();
        for (ASPBodyElement a : this.right) {
            atoms.addAll(a.getAtoms());
        }
        return atoms;
    }

    @Override
    public AggregateElement substitute(Term<?> t, Term<?> v) {
        LinkedList terms = new LinkedList();
        LinkedList<ASPBodyElement> elements = new LinkedList<ASPBodyElement>();
        AggregateElement a = this;
        for (Term<?> term : a.left) {
            terms.add(term.substitute(t, v));
        }
        for (ASPBodyElement aSPBodyElement : a.right) {
            elements.add((ASPBodyElement)aSPBodyElement.substitute((Term)t, (Term)v));
        }
        return new AggregateElement(terms, elements);
    }

    @Override
    public FolSignature getSignature() {
        FolSignature sig = new FolSignature();
        for (Term<?> term : this.left) {
            sig.add(term);
        }
        for (ASPBodyElement aSPBodyElement : this.right) {
            sig.add((Object)aSPBodyElement.getSignature());
        }
        return sig;
    }

    @Override
    public AggregateElement clone() {
        return new AggregateElement(this);
    }

    public List<Term<?>> getLeft() {
        return this.left;
    }

    public List<ASPBodyElement> getRight() {
        return this.right;
    }

    @Override
    public AggregateElement substitute(Map<? extends Term<?>, ? extends Term<?>> map) throws IllegalArgumentException {
        ASPElement e = this;
        for (Term<?> v : map.keySet()) {
            e = e.substitute((Term)v, (Term)map.get(v));
        }
        return e;
    }

    @Override
    public AggregateElement exchange(Term<?> v, Term<?> t) throws IllegalArgumentException {
        if (!v.getSort().equals((Object)t.getSort())) {
            throw new IllegalArgumentException("Terms '" + v + "' and '" + t + "' are of different sorts.");
        }
        Constant temp = new Constant("$TEMP$", v.getSort());
        ASPElement rf = this.substitute((Term)v, (Term)temp);
        rf = ((AggregateElement)rf).substitute((Term)t, (Term)v);
        rf = ((AggregateElement)rf).substitute((Term)temp, (Term)t);
        v.getSort().remove((Term)temp);
        return rf;
    }

    public SortedSet<ASPLiteral> getLiterals() {
        TreeSet<ASPLiteral> literals = new TreeSet<ASPLiteral>();
        for (ASPBodyElement t : this.right) {
            literals.addAll(t.getLiterals());
        }
        return literals;
    }
}

