/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.lp.asp.syntax;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.tweety.logics.commons.syntax.Predicate;
import net.sf.tweety.logics.commons.syntax.interfaces.Term;
import net.sf.tweety.logics.fol.syntax.FolSignature;
import net.sf.tweety.lp.asp.syntax.ASPAtom;
import net.sf.tweety.lp.asp.syntax.ASPBodyElement;
import net.sf.tweety.lp.asp.syntax.ASPLiteral;
import net.sf.tweety.lp.asp.syntax.ASPOperator;

public class ComparativeAtom
extends ASPBodyElement {
    private ASPOperator.BinaryOperator op;
    private Term<?> left;
    private Term<?> right;

    public ComparativeAtom(ASPOperator.BinaryOperator op, Term<?> left, Term<?> right) {
        this.op = op;
        this.left = left;
        this.right = right;
    }

    public ComparativeAtom(ComparativeAtom other) {
        this(other.op, other.left, other.right);
    }

    public String toString() {
        return this.left.toString() + this.op.toString() + this.right.toString();
    }

    @Override
    public SortedSet<ASPLiteral> getLiterals() {
        return new TreeSet<ASPLiteral>();
    }

    @Override
    public Set<Predicate> getPredicates() {
        return new HashSet<Predicate>();
    }

    @Override
    public Set<ASPAtom> getAtoms() {
        return new HashSet<ASPAtom>();
    }

    @Override
    public ComparativeAtom substitute(Term<?> t, Term<?> v) {
        ComparativeAtom cat = new ComparativeAtom(this);
        if (this.left.equals(t)) {
            cat.left = v;
        }
        if (this.right.equals(t)) {
            cat.right = v;
        }
        return cat;
    }

    @Override
    public FolSignature getSignature() {
        FolSignature sig = new FolSignature();
        sig.add(this.left);
        sig.add(this.right);
        return sig;
    }

    @Override
    public ASPBodyElement clone() {
        return new ComparativeAtom(this);
    }

    @Override
    public Class<? extends Predicate> getPredicateCls() {
        return Predicate.class;
    }

    public boolean isLiteral() {
        return false;
    }

    public Set<Term<?>> getTerms() {
        HashSet reval = new HashSet();
        reval.add(this.left);
        reval.add(this.right);
        return reval;
    }

    public ASPOperator.BinaryOperator getOperator() {
        return this.op;
    }

    public Term<?> getLeft() {
        return this.left;
    }

    public Term<?> getRight() {
        return this.right;
    }

    public <C extends Term<?>> Set<C> getTerms(Class<C> cls) {
        HashSet reval = new HashSet();
        reval.addAll(this.left.getTerms(cls));
        reval.addAll(this.right.getTerms(cls));
        return reval;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComparativeAtom other = (ComparativeAtom)obj;
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        if (this.op == null ? other.op != null : !this.op.equals((Object)other.op)) {
            return false;
        }
        return !(this.right == null ? other.right != null : !this.right.equals(other.right));
    }
}

