/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.lp.asp.syntax;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.tweety.commons.util.rules.RuleSet;
import net.sf.tweety.logics.commons.syntax.Constant;
import net.sf.tweety.logics.commons.syntax.Predicate;
import net.sf.tweety.logics.commons.syntax.interfaces.LogicProgram;
import net.sf.tweety.logics.commons.syntax.interfaces.Term;
import net.sf.tweety.logics.fol.syntax.FolSignature;
import net.sf.tweety.lp.asp.syntax.ASPBodyElement;
import net.sf.tweety.lp.asp.syntax.ASPHead;
import net.sf.tweety.lp.asp.syntax.ASPLiteral;
import net.sf.tweety.lp.asp.syntax.ASPRule;
import net.sf.tweety.lp.asp.syntax.DefaultNegation;
import net.sf.tweety.lp.asp.syntax.StrictNegation;

public class Program
extends RuleSet<ASPRule>
implements LogicProgram<ASPHead, ASPBodyElement, ASPRule> {
    private static final long serialVersionUID = -1498770939009078101L;
    private ASPLiteral query;
    private Set<Predicate> output_predicate_whitelist;

    public Program() {
        this.query = null;
        this.output_predicate_whitelist = new HashSet<Predicate>();
    }

    public Program(Collection<ASPRule> rules) {
        super(rules);
        this.query = null;
        this.output_predicate_whitelist = this.getPredicates();
    }

    public Program(ASPLiteral query, Set<ASPRule> rules) {
        super(rules);
        this.query = query;
        this.output_predicate_whitelist = this.getPredicates();
    }

    public Program(Program other) {
        this(other.query, (Set<ASPRule>)((Object)other));
    }

    public void setQuery(ASPLiteral query) {
        this.query = query;
    }

    public void addFact(ASPHead fact) {
        this.add(new ASPRule(fact));
    }

    public void addFacts(ASPHead ... fact) {
        for (ASPHead a : fact) {
            this.addFact(a);
        }
    }

    public FolSignature getMinimalSignature() {
        FolSignature sig = new FolSignature();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ASPRule r = (ASPRule)iterator.next();
            sig.addAll(r.getPredicates());
            sig.addAll(r.getTerms(Constant.class));
        }
        if (this.query != null) {
            sig.addAll(this.query.getPredicates());
            sig.addAll((Collection)this.query.getTerms(Constant.class));
        }
        return sig;
    }

    public Program substitute(Term<?> v, Term<?> t) throws IllegalArgumentException {
        Program reval = new Program();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ASPRule r = (ASPRule)iterator.next();
            reval.add(r.substitute((Term)t, (Term)v));
        }
        if (this.hasQuery()) {
            reval.setQuery((ASPLiteral)this.query.substitute((Term)t, (Term)v));
        }
        return reval;
    }

    public Program substitute(Map<? extends Term<?>, ? extends Term<?>> map) throws IllegalArgumentException {
        Program reval = this;
        for (Term<?> t : map.keySet()) {
            reval = reval.substitute((Term)t, (Term)map.get(t));
        }
        return reval;
    }

    public Program exchange(Term<?> v, Term<?> t) throws IllegalArgumentException {
        Program reval = new Program();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ASPRule r = (ASPRule)iterator.next();
            reval.add(r.exchange((Term)v, (Term)t));
        }
        if (this.hasQuery()) {
            reval.setQuery((ASPLiteral)this.query.exchange((Term)t, (Term)v));
        }
        return reval;
    }

    public String toString() {
        Object r = "{";
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ASPRule a = (ASPRule)iterator.next();
            r = (String)r + a.toString() + " ";
        }
        r = ((String)r).substring(0, ((String)r).length() - 1);
        if (this.hasQuery()) {
            r = (String)r + " " + this.query.toString() + "?";
        }
        r = (String)r + "}";
        return r;
    }

    public boolean isGround() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ASPRule r = (ASPRule)iterator.next();
            if (r.isGround()) continue;
            return false;
        }
        return !this.hasQuery() || this.query.isGround();
    }

    public Program clone() {
        return new Program(this);
    }

    public void setOutputWhitelist(Collection<Predicate> ps) {
        this.output_predicate_whitelist = (Set)ps;
    }

    public Set<Predicate> getOutputWhitelist() {
        return this.output_predicate_whitelist;
    }

    private Set<Predicate> getPredicates() {
        HashSet<Predicate> prs = new HashSet<Predicate>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ASPRule r = (ASPRule)iterator.next();
            prs.addAll(r.getPredicates());
        }
        if (this.hasQuery()) {
            prs.add(this.query.getPredicate());
        }
        return prs;
    }

    public boolean hasQuery() {
        return this.query != null;
    }

    public ASPLiteral getQuery() {
        return this.query;
    }

    public Program reduct(Set<ASPLiteral> state) {
        Program p = new Program();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ASPRule r = (ASPRule)iterator.next();
            ASPRule r2 = new ASPRule();
            r2.setConclusion(r.getConclusion());
            boolean vio = false;
            for (ASPBodyElement e : r.getPremise()) {
                if (e instanceof DefaultNegation) {
                    if (!state.contains(((DefaultNegation)e).getLiteral())) continue;
                    vio = true;
                    break;
                }
                r2.addPremise(e);
            }
            if (vio) continue;
            p.add(r2);
        }
        return p;
    }

    public static Program defaultification(Program p) {
        Program reval = new Program();
        Iterator iterator = p.iterator();
        while (iterator.hasNext()) {
            ASPRule origRule = (ASPRule)iterator.next();
            ASPRule defRule = new ASPRule();
            if (!origRule.isConstraint()) {
                ASPLiteral head = origRule.getHead().iterator().next();
                StrictNegation neg = new StrictNegation(head.getAtom());
                defRule.addPremises(origRule.getBody());
                DefaultNegation defaultificationLit = null;
                if (head instanceof StrictNegation) {
                    defRule.addToHead(neg);
                    defaultificationLit = new DefaultNegation(head.getAtom());
                } else {
                    defRule.addToHead(head);
                    defaultificationLit = new DefaultNegation(neg);
                }
                if (defaultificationLit != null && !defRule.getBody().contains(defaultificationLit)) {
                    defRule.addPremise(defaultificationLit);
                }
            } else {
                defRule.addPremises(origRule.getBody());
            }
            reval.add(defRule);
        }
        return reval;
    }

    public void addFact(ASPLiteral fact) {
        this.add(new ASPRule(fact));
    }

    void addFacts(ASPLiteral ... facts) {
        for (ASPLiteral l : facts) {
            this.addFact(l);
        }
    }

    public boolean isExtendedProgram() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ASPRule r = (ASPRule)iterator.next();
            if (r.getHead().size() <= 1) continue;
            return false;
        }
        return true;
    }

    public void add(Program other) {
        Iterator iterator = other.iterator();
        while (iterator.hasNext()) {
            ASPRule r = (ASPRule)iterator.next();
            this.add(r);
        }
        if (other.hasQuery()) {
            if (this.hasQuery()) {
                throw new IllegalArgumentException("Program already has a query.");
            }
            this.query = other.getQuery();
        }
    }

    public boolean isSafe() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ASPRule r = (ASPRule)iterator.next();
            if (r.isSafe().booleanValue()) continue;
            return false;
        }
        return true;
    }
}

