/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.lp.asp.writer;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import net.sf.tweety.logics.commons.syntax.Predicate;
import net.sf.tweety.lp.asp.syntax.ASPBodyElement;
import net.sf.tweety.lp.asp.syntax.ASPRule;
import net.sf.tweety.lp.asp.syntax.Program;

public class ClingoWriter {
    Writer writer;
    private boolean usePredicateWhitelist = false;

    public ClingoWriter(Writer writer) {
        this.writer = writer;
    }

    public ClingoWriter() {
        this.writer = new StringWriter();
    }

    public ClingoWriter(Writer writer, boolean b) {
        this.writer = writer;
        this.usePredicateWhitelist = b;
    }

    public void printProgram(Program p) throws IOException {
        Iterator<Predicate> iterator = p.iterator();
        while (iterator.hasNext()) {
            ASPRule r = (ASPRule)iterator.next();
            this.writer.write(this.printRule(r) + ".\n");
        }
        if (this.usePredicateWhitelist) {
            for (Predicate pr : p.getOutputWhitelist()) {
                this.writer.write("\n #show " + pr.getName() + "/" + pr.getArity() + ".\n");
            }
        }
    }

    private String printRule(ASPRule r) {
        Object result = "";
        if (!r.isConstraint()) {
            result = (String)result + r.getHead().toString();
        }
        if (!r.isFact()) {
            result = (String)result + " :- ";
            List<ASPBodyElement> body = r.getBody();
            for (int i = 0; i < body.size() - 1; ++i) {
                result = (String)result + body.get(i).toString() + ",";
            }
            result = (String)result + body.get(body.size() - 1).toString();
        }
        return result;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void usePredicateWhitelist(boolean b) {
        this.usePredicateWhitelist = b;
    }
}

