/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.machinelearning;

public class TrainingParameter {
    private String name;
    private double value;
    private double defaultValue;
    private double upperBound;
    private double lowerBound;

    public TrainingParameter(String name, double defaultValue, double upperBound, double lowerBound) {
        this(name, defaultValue, defaultValue, upperBound, lowerBound);
    }

    public TrainingParameter(String name, double value, double defaultValue, double lowerBound, double upperBound) {
        if (upperBound < value || upperBound < defaultValue || lowerBound > value || lowerBound > defaultValue) {
            throw new IllegalArgumentException("Illegal value of default value given bounds.");
        }
        this.name = name;
        this.value = value;
        this.defaultValue = defaultValue;
        this.upperBound = upperBound;
        this.lowerBound = lowerBound;
    }

    public TrainingParameter instantiate(double value) {
        if (this.lowerBound <= value && this.upperBound >= value) {
            return new TrainingParameter(this.name, value, this.defaultValue, this.lowerBound, this.upperBound);
        }
        throw new IllegalArgumentException("Value outside of accepted boundaries.");
    }

    public TrainingParameter instantiateWithDefaultValue() {
        return new TrainingParameter(this.name, this.defaultValue, this.defaultValue, this.lowerBound, this.upperBound);
    }

    public String getName() {
        return this.name;
    }

    public double getValue() {
        return this.value;
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public String toString() {
        return "<" + this.name + "," + this.value + "," + this.defaultValue + "," + this.lowerBound + "," + this.upperBound + ">";
    }
}

