/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.machinelearning.assoc;

import java.util.Collection;
import java.util.HashSet;
import net.sf.tweety.machinelearning.assoc.AbstractAssociationRuleMiner;
import net.sf.tweety.machinelearning.assoc.AssociationRule;

public class AprioriMiner<T>
extends AbstractAssociationRuleMiner<T> {
    private double minsupport;
    private double minconf;

    public AprioriMiner(double minsupport, double minconf) {
        this.minsupport = minsupport;
        this.minconf = minconf;
    }

    @Override
    public Collection<AssociationRule<T>> mineRules(Collection<Collection<T>> database, int conclusion_limit, int total_limit) {
        Collection<Collection<T>> sets = this.mineFrequentSets(database, total_limit);
        HashSet<AssociationRule<T>> rules = new HashSet<AssociationRule<T>>();
        if (conclusion_limit < 1) {
            return rules;
        }
        for (Collection<T> set : sets) {
            HashSet<Collection<T>> lastLevel_conc = new HashSet<Collection<T>>();
            for (T item : set) {
                AssociationRule<T> rule = new AssociationRule<T>();
                for (T item2 : set) {
                    if (item == item2) {
                        rule.addToConclusion(item2);
                        continue;
                    }
                    rule.addToPremise(item2);
                }
                if (!(rule.confidence(database) >= this.minconf)) continue;
                rules.add(rule);
                lastLevel_conc.add(rule.getConclusion());
            }
            int card = 1;
            while (!lastLevel_conc.isEmpty() && conclusion_limit > card) {
                Collection<Collection<T>> nextLevel_conc = this.nextLevel(lastLevel_conc, card);
                ++card;
                lastLevel_conc.clear();
                for (Collection<T> conc : nextLevel_conc) {
                    AssociationRule<T> rule = new AssociationRule<T>();
                    for (T item2 : set) {
                        if (conc.contains(item2)) {
                            rule.addToConclusion(item2);
                            continue;
                        }
                        rule.addToPremise(item2);
                    }
                    if (!(rule.confidence(database) >= this.minconf)) continue;
                    rules.add(rule);
                    lastLevel_conc.add(rule.getConclusion());
                }
            }
        }
        return rules;
    }

    /*
     * WARNING - void declaration
     */
    private Collection<Collection<T>> mineFrequentSets(Collection<Collection<T>> database, int maxsize) {
        void var6_10;
        HashSet<Collection<T>> sets = new HashSet<Collection<T>>();
        HashSet items = new HashSet();
        for (Collection collection : database) {
            items.addAll(collection);
        }
        for (Collection<Object> collection : items) {
            if (!(AssociationRule.support(collection, database) >= this.minsupport)) continue;
            HashSet<Collection<Object>> set = new HashSet<Collection<Object>>();
            set.add(collection);
            sets.add(set);
        }
        HashSet<Collection<T>> lastLevel = new HashSet<Collection<T>>();
        lastLevel.addAll(sets);
        boolean bl = true;
        while (!lastLevel.isEmpty() && var6_10 < maxsize) {
            Collection<Collection<T>> nextLevel = this.nextLevel(lastLevel, (int)var6_10);
            ++var6_10;
            lastLevel.clear();
            for (Collection<T> cand : nextLevel) {
                if (!(AssociationRule.support(cand, database) >= this.minsupport)) continue;
                lastLevel.add(cand);
                sets.add(cand);
            }
        }
        return sets;
    }

    private Collection<Collection<T>> nextLevel(Collection<Collection<T>> lastLevel, int cardinality) {
        HashSet<Collection<T>> nextLevel = new HashSet<Collection<T>>();
        for (Collection<T> set1 : lastLevel) {
            for (Collection<T> set2 : lastLevel) {
                HashSet<T> candidate = new HashSet<T>(set1);
                candidate.addAll(set2);
                if (candidate.size() != cardinality + 1 || !this.checkSubsetCondition(candidate, lastLevel)) continue;
                nextLevel.add(candidate);
            }
        }
        return nextLevel;
    }

    private boolean checkSubsetCondition(Collection<T> set, Collection<Collection<T>> sets) {
        HashSet<T> sub = new HashSet<T>();
        for (T item : set) {
            sub.clear();
            sub.addAll(set);
            sub.remove(item);
            if (sets.contains(sub)) continue;
            return false;
        }
        return true;
    }
}

