/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.machinelearning.assoc;

import java.util.Collection;
import java.util.HashSet;

public class AssociationRule<T> {
    private Collection<T> premise;
    private Collection<T> conclusion;

    public AssociationRule() {
        this(new HashSet(), new HashSet());
    }

    public AssociationRule(Collection<T> premise, Collection<T> conclusion) {
        this.premise = premise;
        this.conclusion = conclusion;
    }

    public boolean addToPremise(T t) {
        return this.premise.add(t);
    }

    public boolean addToConclusion(T t) {
        return this.conclusion.add(t);
    }

    public Collection<T> getPremise() {
        return this.premise;
    }

    public Collection<T> getConclusion() {
        return this.conclusion;
    }

    public static <S> double support(S item, Collection<Collection<S>> database) {
        double cnt = 0.0;
        for (Collection<S> t : database) {
            if (!t.contains(item)) continue;
            cnt += 1.0;
        }
        return cnt / (double)database.size();
    }

    public static <S> double support(Collection<S> itemset, Collection<Collection<S>> database) {
        double cnt = 0.0;
        for (Collection<S> t : database) {
            if (!t.containsAll(itemset)) continue;
            cnt += 1.0;
        }
        return cnt / (double)database.size();
    }

    public double support(Collection<Collection<T>> database) {
        HashSet<T> all = new HashSet<T>(this.premise);
        all.addAll(this.conclusion);
        return AssociationRule.support(all, database);
    }

    public double confidence(Collection<Collection<T>> database) {
        return this.support(database) / AssociationRule.support(this.premise, database);
    }

    public String toString() {
        return this.premise + "->" + this.conclusion;
    }
}

